/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;
import org.jvnet.substance.painter.MatteGradientPainter;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.MarbleNoiseHeaderPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class AutumnSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Autumn";

    public AutumnSkin() {
        SubstanceTheme defaultTheme;
        SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(), "Autumn Active", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme disabledTheme = defaultTheme = new SubstanceTheme(new DefaultScheme(), "Autumn Default", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme activeTitleTheme = defaultTheme;
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme){

            public Color getLightBackgroundColor() {
                return SubstanceColorUtilities.getInterpolatedColor(this.defaultTheme.getColorScheme().getUltraLightColor(), this.defaultTheme.getColorScheme().getExtraLightColor(), 0.5);
            }

            public Color getDisabledForegroundColor() {
                return SubstanceColorUtilities.getInterpolatedColor(this.defaultTheme.getColorScheme().getForegroundColor(), this.defaultTheme.getColorScheme().getLightColor(), 0.6f);
            }
        };
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        theme.registerComponentStateTheme(disabledTheme, 0.6f, false, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new MatteGradientPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
        MarbleNoiseHeaderPainter titlePainter = new MarbleNoiseHeaderPainter(false, false);
        titlePainter.setPaintingSeparators(true);
        titlePainter.setPaintingToolbarDropShadows(true);
        titlePainter.setTextureAlpha(0.7f);
        this.titlePainter = titlePainter;
        this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.75f);
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class DefaultScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FFF2DF");
        private static final Color mainExtraLightColor = Color.decode("#FFE3C5");
        private static final Color mainLightColor = Color.decode("#FDD1A4");
        private static final Color mainMidColor = Color.decode("#FBCD9C");
        private static final Color mainDarkColor = Color.decode("#FCC896");
        private static final Color mainUltraDarkColor = Color.decode("#AC623B");
        private static final Color foregroundColor = Color.decode("#AC623B");

        protected DefaultScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class ActiveScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FDDDAC");
        private static final Color mainExtraLightColor = Color.decode("#FCEF9F");
        private static final Color mainLightColor = Color.decode("#FCD592");
        private static final Color mainMidColor = Color.decode("#F9BE84");
        private static final Color mainDarkColor = Color.decode("#F8B87A");
        private static final Color mainUltraDarkColor = Color.decode("#AC623B");
        private static final Color foregroundColor = Color.decode("#AC623B");

        protected ActiveScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

