/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceHighlightManager;

public class SubstanceComplexTheme
extends SubstanceTheme {
    protected SubstanceTheme activeTheme;
    protected SubstanceTheme defaultTheme;
    protected SubstanceTheme disabledTheme;
    protected SubstanceTheme activeTitlePaneTheme;
    protected SubstanceTheme defaultTitlePaneTheme;
    protected SubstanceTheme watermarkTheme;
    protected Map<ComponentState, SubstanceTheme> stateThemeMap;
    protected Map<ComponentState, Float> stateThemeAlphaMap;
    protected Map<ComponentState, SubstanceTheme> stateHighlightThemeMap;
    protected Map<ComponentState, Float> stateHighlightThemeAlphaMap;
    protected SubstanceGradientPainter nonActivePainter;
    protected double selectedTabFadeStart;
    protected double selectedTabFadeEnd;
    protected boolean useSameBackgroundColor;

    public SubstanceComplexTheme(String displayName, SubstanceTheme.ThemeKind themeKind, SubstanceTheme activeTheme, SubstanceTheme defaultTheme, SubstanceTheme disabledTheme, SubstanceTheme activeTitlePaneTheme) {
        this(displayName, themeKind, activeTheme, defaultTheme, disabledTheme, activeTitlePaneTheme, defaultTheme);
    }

    public SubstanceComplexTheme(String displayName, SubstanceTheme.ThemeKind themeKind, SubstanceTheme activeTheme, SubstanceTheme defaultTheme, SubstanceTheme disabledTheme, SubstanceTheme activeTitlePaneTheme, SubstanceTheme watermarkTheme) {
        super(defaultTheme.getColorScheme(), displayName, themeKind);
        this.activeTheme = activeTheme;
        this.defaultTheme = defaultTheme;
        this.disabledTheme = disabledTheme;
        this.activeTitlePaneTheme = activeTitlePaneTheme;
        this.watermarkTheme = watermarkTheme;
        this.selectedTabFadeStart = 1.0;
        this.selectedTabFadeEnd = 1.0;
        this.useSameBackgroundColor = false;
        this.stateThemeMap = new HashMap<ComponentState, SubstanceTheme>();
        this.stateThemeAlphaMap = new HashMap<ComponentState, Float>();
        this.stateHighlightThemeMap = new HashMap<ComponentState, SubstanceTheme>();
        this.stateHighlightThemeAlphaMap = new HashMap<ComponentState, Float>();
    }

    public SubstanceTheme getActiveTheme() {
        return this.activeTheme;
    }

    public SubstanceTheme getDefaultTheme() {
        return this.defaultTheme;
    }

    public SubstanceTheme getDisabledTheme() {
        return this.disabledTheme;
    }

    public SubstanceTheme getActiveTitlePaneTheme() {
        return this.activeTitlePaneTheme;
    }

    public SubstanceTheme getDefaultTitlePaneTheme() {
        if (this.defaultTitlePaneTheme == null) {
            return this.getActiveTitlePaneTheme();
        }
        return this.defaultTitlePaneTheme;
    }

    public Color getLightBackgroundColor() {
        if (this.useSameBackgroundColor) {
            return this.getBackgroundColor();
        }
        return super.getLightBackgroundColor();
    }

    public SubstanceTheme getFirstTheme() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("First " + this.getDisplayName(), this.getKind(), this.getActiveTheme().getFirstTheme(), this.getDefaultTheme().getFirstTheme(), this.getDisabledTheme().getFirstTheme(), this.getActiveTitlePaneTheme().getFirstTheme());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme getSecondTheme() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Second " + this.getDisplayName(), this.getKind(), this.getActiveTheme().getSecondTheme(), this.getDefaultTheme().getSecondTheme(), this.getDisabledTheme().getSecondTheme(), this.getActiveTitlePaneTheme().getSecondTheme());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Saturated [" + toSaturateEverything + "] " + this.getDisplayName() + " " + (int)(100.0 * saturateFactor) + "%", this.getKind(), this.getActiveTheme().saturate(saturateFactor, toSaturateEverything), toSaturateEverything ? this.getDefaultTheme().saturate(saturateFactor, true) : this.getDefaultTheme(), toSaturateEverything ? this.getDisabledTheme().saturate(saturateFactor, true) : this.getDisabledTheme(), toSaturateEverything ? this.getActiveTitlePaneTheme().saturate(saturateFactor, true) : this.getActiveTitlePaneTheme(), toSaturateEverything ? this.getWatermarkTheme().saturate(saturateFactor, true) : this.getWatermarkTheme());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme shade(double shadeFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Shade " + this.getDisplayName() + " " + (int)(100.0 * shadeFactor) + "%", this.getKind(), this.getActiveTheme().shade(shadeFactor), this.getDefaultTheme().shade(shadeFactor), this.getDisabledTheme().shade(shadeFactor), this.getActiveTitlePaneTheme().shade(shadeFactor), this.getWatermarkTheme().shade(shadeFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tint(double tintFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tint " + this.getDisplayName() + " " + (int)(100.0 * tintFactor) + "%", this.getKind(), this.getActiveTheme().tint(tintFactor), this.getDefaultTheme().tint(tintFactor), this.getDisabledTheme().tint(tintFactor), this.getActiveTitlePaneTheme().tint(tintFactor), this.getWatermarkTheme().tint(tintFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tone(double toneFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tone " + this.getDisplayName() + " " + (int)(100.0 * toneFactor) + "%", this.getKind(), this.getActiveTheme().tone(toneFactor), this.getDefaultTheme().tone(toneFactor), this.getDisabledTheme().tone(toneFactor), this.getActiveTitlePaneTheme().tone(toneFactor), this.getWatermarkTheme().tone(toneFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme invert() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Inverted " + this.getDisplayName(), this.getKind(), this.getActiveTheme().invert(), this.getDefaultTheme().invert(), this.getDisabledTheme().invert(), this.getActiveTitlePaneTheme().invert(), this.getWatermarkTheme().invert());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme negate() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Negated " + this.getDisplayName(), this.getKind(), this.getActiveTheme().negate(), this.getDefaultTheme().negate(), this.getDisabledTheme().negate(), this.getActiveTitlePaneTheme().negate(), this.getWatermarkTheme().negate());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Hue-shift " + this.getDisplayName() + " " + (int)(100.0 * hueShiftFactor) + "%", this.getKind(), this.getActiveTheme().hueShift(hueShiftFactor), this.getDefaultTheme().hueShift(hueShiftFactor), this.getDisabledTheme().hueShift(hueShiftFactor), this.getActiveTitlePaneTheme().hueShift(hueShiftFactor), this.getWatermarkTheme().hueShift(hueShiftFactor));
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme protanopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Protanopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().protanopia(), this.getDefaultTheme().protanopia(), this.getDisabledTheme().protanopia(), this.getActiveTitlePaneTheme().protanopia(), this.getWatermarkTheme().protanopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme tritanopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Tritanopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().tritanopia(), this.getDefaultTheme().tritanopia(), this.getDisabledTheme().tritanopia(), this.getActiveTitlePaneTheme().tritanopia(), this.getWatermarkTheme().tritanopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme deuteranopia() {
        SubstanceComplexTheme result = new SubstanceComplexTheme("Deuteranopia " + this.getDisplayName(), this.getKind(), this.getActiveTheme().deuteranopia(), this.getDefaultTheme().deuteranopia(), this.getDisabledTheme().deuteranopia(), this.getActiveTitlePaneTheme().deuteranopia(), this.getWatermarkTheme().deuteranopia());
        this.copyTo(result);
        return result;
    }

    public SubstanceTheme getWatermarkTheme() {
        return this.watermarkTheme;
    }

    public SubstanceGradientPainter getNonActivePainter() {
        if (this.nonActivePainter != null) {
            return this.nonActivePainter;
        }
        return super.getNonActivePainter();
    }

    public void setNonActivePainter(SubstanceGradientPainter nonActivePainter) {
        this.nonActivePainter = nonActivePainter;
    }

    public void setDefaultTitlePaneTheme(SubstanceTheme defaultTitlePaneTheme) {
        this.defaultTitlePaneTheme = defaultTitlePaneTheme;
    }

    public void setDefaultTheme(SubstanceTheme defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public void setDisabledTheme(SubstanceTheme disabledTheme) {
        this.disabledTheme = disabledTheme;
    }

    public void setActiveTheme(SubstanceTheme activeTheme) {
        this.activeTheme = activeTheme;
    }

    public void setActiveTitlePaneTheme(SubstanceTheme activeTitlePaneTheme) {
        this.activeTitlePaneTheme = activeTitlePaneTheme;
    }

    public void setWatermarkTheme(SubstanceTheme watermarkTheme) {
        this.watermarkTheme = watermarkTheme;
    }

    public double getSelectedTabFadeStart() {
        return this.selectedTabFadeStart;
    }

    public double getSelectedTabFadeEnd() {
        return this.selectedTabFadeEnd;
    }

    public void setSelectedTabFadeEnd(double selectedTabFadeEnd) {
        this.selectedTabFadeEnd = selectedTabFadeEnd;
    }

    public void setSelectedTabFadeStart(double selectedTabFadeStart) {
        this.selectedTabFadeStart = selectedTabFadeStart;
    }

    public void setUseSameBackgroundColor(boolean useSameBackgroundColor) {
        this.useSameBackgroundColor = useSameBackgroundColor;
    }

    public void registerComponentStateTheme(SubstanceTheme stateTheme, float alpha, boolean useForHighlights, ComponentState ... states) {
        if (states != null) {
            for (ComponentState state : states) {
                this.stateThemeMap.put(state, stateTheme);
                this.stateThemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
        if (useForHighlights) {
            this.registerComponentHighlightStateTheme(stateTheme, alpha, states);
        }
    }

    public void registerComponentStateTheme(SubstanceTheme stateTheme, boolean useForHighlights, ComponentState ... states) {
        this.registerComponentStateTheme(stateTheme, 1.0f, useForHighlights, states);
    }

    public void registerComponentHighlightStateTheme(SubstanceTheme stateHighlightTheme, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.stateHighlightThemeMap.containsKey((Object)state) || !state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                this.stateHighlightThemeMap.put(state, stateHighlightTheme);
            }
        } else {
            for (ComponentState state : states) {
                this.stateHighlightThemeMap.put(state, stateHighlightTheme);
            }
        }
    }

    public void registerComponentHighlightStateTheme(SubstanceTheme stateHighlightTheme, float alpha, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (!state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                if (!this.stateHighlightThemeMap.containsKey((Object)state)) {
                    this.stateHighlightThemeMap.put(state, stateHighlightTheme);
                }
                if (this.stateHighlightThemeAlphaMap.containsKey((Object)state)) continue;
                this.stateHighlightThemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        } else {
            for (ComponentState state : states) {
                this.stateHighlightThemeMap.put(state, stateHighlightTheme);
                this.stateHighlightThemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public SubstanceTheme getTheme(Component comp, ComponentState componentState) {
        if (SubstanceHighlightManager.getInstance().toUseHighlightTheme(comp)) {
            SubstanceTheme registered = this.stateHighlightThemeMap.get((Object)componentState);
            if (registered != null) {
                return registered;
            }
        } else {
            SubstanceTheme registered = this.stateThemeMap.get((Object)componentState);
            if (registered != null) {
                return registered;
            }
        }
        return super.getTheme(comp, componentState);
    }

    public SubstanceTheme getHighlightTheme(Component comp, ComponentState componentState) {
        SubstanceTheme registered = this.stateHighlightThemeMap.get((Object)componentState);
        if (registered != null) {
            return registered;
        }
        return super.getHighlightTheme(comp, componentState);
    }

    public float getHighlightThemeAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateHighlightThemeAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return super.getHighlightThemeAlpha(comp, componentState);
    }

    public float getThemeAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateThemeAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return super.getThemeAlpha(comp, componentState);
    }

    protected void copyTo(SubstanceComplexTheme dst) {
        dst.setNonActivePainter(this.nonActivePainter);
        dst.setSelectedTabFadeStart(this.selectedTabFadeStart);
        dst.setSelectedTabFadeEnd(this.selectedTabFadeEnd);
        dst.setUseSameBackgroundColor(this.useSameBackgroundColor);
        for (Map.Entry<ComponentState, SubstanceTheme> entry : this.stateThemeMap.entrySet()) {
            dst.registerComponentStateTheme(entry.getValue(), false, entry.getKey());
        }
        for (Map.Entry<ComponentState, SubstanceTheme> entry : this.stateHighlightThemeMap.entrySet()) {
            dst.registerComponentHighlightStateTheme(entry.getValue(), entry.getKey());
        }
    }
}

