package com.izforge.izpack.panels;

import javax.swing.*;
import java.awt.*;

/**
 * Created by dsoukhov on 16/03/17.
 */
public class JTextMessagePane extends JTextArea{

    private int width;
    private FontMetrics fm;

    public JTextMessagePane(String msg, int maxWidth, FontMetrics fm) {
        this.fm = fm;
        setEditable(false);
        setFocusable(false);
        setBackground(null);

        int textWidth = getMessageWidth(msg);
        if (textWidth > maxWidth) {
            setWrapStyleWord(true);
            setLineWrap(true);
            setMargin(new Insets(2, 0, 2, 0));

            width = maxWidth;
            setPreferredSize(new Dimension(width, getPreferredSize().height * rowCountWrapLine(msg)));
        }

        setText(msg);
    }

    private int getMessageWidth(String msg){
        int max = 0;
        String[] lines = msg.split("\\n");

        if(lines.length == 1)return fm.stringWidth(msg);

        //if contains newline textWidth is the largest string segment
        for(String line:lines) {
            max = max < fm.stringWidth(line) ? fm.stringWidth(line): max;
        }
        return max + fm.stringWidth("\\n");
    }

    private int rowCountWrapLine(String text){
        int rowCount = 1;
        int widthCount = 0;

        String[] words = text.split("(?<=\\s)");

        if(words.length == 1) return rowCount + rowCountWrapWord(words[0]);

        for(int i =0; i < words.length-1; i++) {
            String word = words[i];
            String nextWord = words[i+1];
            if(fm.stringWidth(word) > width) {
                rowCount += rowCountWrapWord(word);
                widthCount = fm.stringWidth(word) % width;
            } else {
                widthCount += fm.stringWidth(word);
                int remainder = width - widthCount;

                //increment row count if there is no room left on current row or if word has a newline char
                if (remainder < fm.stringWidth(nextWord) ||word.contains("\n")){
                    rowCount++;
                    widthCount = 0;
                }
            }
        }
        String finalWord = words[words.length-1];
        if(fm.stringWidth(finalWord) > width) rowCount += rowCountWrapWord(finalWord);
        return rowCount;
    }


    private int rowCountWrapWord(String word){
        int additionalRows = 0;
        int widthCount = 0;

        char[] letters = word.toCharArray();

        for(int i =0; i < letters.length-1; i++) {
            char curChar = letters[i];
            char nextChar = letters[i+1];
            widthCount += fm.charWidth(curChar);
            int remainder = width - widthCount;

            if (remainder < fm.charWidth(nextChar)) {
                additionalRows++;
                widthCount = 0;
            }
        }
        return additionalRows;
    }
}
