/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocException;
import com.sap.conn.idoc.IDocRecord;
import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocSegment;

public class IDocElementException
extends IDocException {
    private static final long serialVersionUID = 1000L;
    private IDocRecord m_record = null;
    private String m_fieldName = null;

    protected IDocElementException(int group, String detailMessage) {
        super(group, detailMessage);
    }

    protected IDocElementException(int group, String detailMessage, Throwable cause) {
        super(group, detailMessage, cause);
    }

    protected IDocElementException(int group, IDocRecord record, String detailMessage) {
        this(group, detailMessage);
        this.m_record = record;
    }

    protected IDocElementException(int group, IDocRecord record, String detailMessage, Throwable cause) {
        this(group, detailMessage, cause);
        this.m_record = record;
    }

    protected IDocElementException(int group, IDocRecord record, String fieldName, String detailMessage) {
        this(group, detailMessage);
        this.m_record = record;
        this.m_fieldName = fieldName;
    }

    protected IDocElementException(int group, IDocRecord record, String fieldName, String detailMessage, Throwable cause) {
        this(group, detailMessage, cause);
        this.m_record = record;
        this.m_fieldName = fieldName;
    }

    public IDocDocument getDocument() {
        if (this.m_record instanceof IDocDocument) {
            return (IDocDocument)this.m_record;
        }
        if (this.m_record instanceof IDocSegment) {
            return ((IDocSegment)this.m_record).getDocument();
        }
        return null;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public String getMessage() {
        String fieldName;
        IDocRecord record;
        IDocSegment segment;
        String detailMessage = super.getMessage();
        StringBuilder message = new StringBuilder(detailMessage.length() + 300);
        message.append(detailMessage);
        String value = "\n";
        IDocDocument document = this.getDocument();
        if (document != null) {
            message.append(value).append("DOCUMENT: type=").append(document.getIDocType());
            value = document.getIDocTypeExtension();
            if (value != null && value.length() > 0) {
                message.append(", type extension=").append(value);
            }
            if ((value = document.getIDocNumber()) != null && value.length() > 0) {
                message.append(", number=").append(value);
            }
            value = "; ";
        }
        if ((segment = this.getSegment()) != null) {
            message.append(value).append("SEGMENT: type=").append(segment.getType());
            message.append(", definition=").append(segment.getDefinition());
            value = "; ";
        }
        if ((record = this.getRecord()) != null && document == null && segment == null) {
            IDocRecordMetaData metaData = record.getRecordMetaData();
            if (metaData != null) {
                value = metaData.getName();
            }
            if (value != null) {
                message.append("\nRECORD: meta data name=").append(value);
                value = "; ";
            }
        }
        if ((fieldName = this.getFieldName()) != null) {
            message.append(value).append("FIELD: name=").append(fieldName);
            if (record != null) {
                try {
                    IDocRecordMetaData metaData = record.getRecordMetaData();
                    if (metaData != null) {
                        value = metaData.getDatatype(fieldName).name();
                        message.append(", datatype=").append(value);
                    }
                    value = record.getString(fieldName);
                    message.append(", value=").append(value);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return message.toString();
    }

    public IDocRecord getRecord() {
        return this.m_record;
    }

    public IDocSegment getSegment() {
        if (this.m_record instanceof IDocSegment) {
            return (IDocSegment)this.m_record;
        }
        return null;
    }
}

