/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc;

public class IDocException
extends Exception {
    private static final long serialVersionUID = 1000L;
    public static final int IDOC_ERROR_INITIALIZATION = 0;
    public static final int IDOC_ERROR_SYNTAX = 1;
    public static final int IDOC_ERROR_UNSUPPORTED_OPERATION = 2;
    public static final int IDOC_ERROR_METADATA_UNAVAILABLE = 3;
    public static final int IDOC_ERROR_ILLEGAL_TYPE = 4;
    public static final int IDOC_ERROR_FIELD_NOT_FOUND = 5;
    public static final int IDOC_ERROR_FIELD_CONVERSION = 6;
    public static final int IDOC_ERROR_PARSE_FAILURE = 7;
    public static final int IDOC_ERROR_NO_QUEUE_HANDLER = 8;
    private int m_group;

    public IDocException(int group, String detailMessage) {
        this(group, detailMessage, null);
    }

    public IDocException(int group, String detailMessage, Throwable cause) {
        super(detailMessage, cause);
        this.m_group = group;
    }

    public final int getGroup() {
        return this.m_group;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getKey() {
        switch (this.m_group) {
            case 0: {
                return "IDOC_ERROR_INITIALIZATION";
            }
            case 1: {
                return "IDOC_ERROR_SYNTAX";
            }
            case 2: {
                return "IDOC_ERROR_UNSUPPORTED_OPERATION";
            }
            case 3: {
                return "IDOC_ERROR_METADATA_UNAVAILABLE";
            }
            case 4: {
                return "IDOC_ERROR_ILLEGAL_TYPE";
            }
            case 5: {
                return "IDOC_ERROR_FIELD_NOT_FOUND";
            }
            case 6: {
                return "IDOC_ERROR_FIELD_CONVERSION";
            }
            case 7: {
                return "IDOC_ERROR_PARSE_FAILURE";
            }
            case 8: {
                return "IDOC_ERROR_NO_QUEUE_HANDLER";
            }
        }
        return "IDOC_ERROR_UNKNOWN";
    }

    public String getMessage() {
        String detailMessage = super.getMessage();
        StringBuilder message = new StringBuilder(detailMessage.length() + 40);
        message.append('(').append(this.m_group).append(") ");
        message.append(this.getKey()).append(": ");
        message.append(detailMessage);
        return message.toString();
    }
}

