/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.rt.util.AboutDialog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

public final class About
extends AboutDialog {
    private static final String NOT_FOUND = "not found";
    private static final String UNKNOWN = "unknown";

    public About() {
        super("SAP Java IDoc Class Library");
        PrintWriter pw;
        StringWriter sw;
        String idoc_path = NOT_FOUND;
        String jco_path = NOT_FOUND;
        String idoc_version = "3.0.10 (2013-08-15)";
        String jco_version = UNKNOWN;
        String idoc_error = null;
        String jco_error = null;
        try {
            idoc_path = this.getOwnFilePath();
            idoc_version = JCoIDoc.getVersion();
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            idoc_error = sw.toString();
            System.out.println(idoc_error);
        }
        try {
            Class<?> jcoClass = Class.forName("com.sap.conn.jco.JCo");
            jco_path = About.getFilePathToClass(jcoClass);
            Method getVersionM = jcoClass.getMethod("getVersion", null);
            jco_version = (String)getVersionM.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            jco_error = sw.toString();
            System.out.println(jco_error);
        }
        AboutDialog.Section section = new AboutDialog.Section("Versions");
        section.addEntry("IDoc API", idoc_version);
        section.addEntry("JCo API", jco_version);
        this.addSection(section);
        section = new AboutDialog.Section("Library Paths");
        section.addEntry("Path to IDoc archive", idoc_path);
        section.addEntry("Path to JCo archive", jco_path);
        this.addSection(section);
        if (idoc_error != null || jco_error != null) {
            section = new AboutDialog.Section("Initialization");
            if (idoc_error != null) {
                section.addEntry("IDoc error", idoc_error);
            }
            if (jco_error != null) {
                section.addEntry("JCo error", jco_error);
            }
            this.addSection(section);
        }
    }

    public static void main(String[] args) {
        new About().show(args);
    }
}

