/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.rt.DefaultIDocHandlerFactory;
import com.sap.conn.idoc.jco.rt.DefaultJCoIDocCallHandlerFactory;
import com.sap.conn.idoc.jco.rt.DefaultJCoIDocServerWorker;
import com.sap.conn.idoc.jco.rt.JCoIDocRepositoryManager;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.DefaultServerWorker;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import java.util.Properties;

public class DefaultJCoIDocServer
extends DefaultServer
implements JCoIDocServer {
    private DefaultServer.RepositoryBox<IDocRepository> idocRepositoryBox;
    private JCoIDocHandlerFactory idocHandlerFactory;
    private boolean usePartnerProfileRelease = false;
    private boolean enforceIDocHandlerFactory = false;

    protected DefaultJCoIDocServer(Properties serverProperties) throws JCoException {
        super(serverProperties);
        String value;
        DefaultServer.MappingRuleParser rulesParser;
        String repositoryDestination = this.getRepositoryDestination();
        if (repositoryDestination != null) {
            JCoDestination destination = JCoDestinationManager.getDestination((String)repositoryDestination);
            this.setIDocRepository(JCoIDocRepositoryManager.getIDocRepository(destination));
        }
        if ((rulesParser = DefaultServer.MappingRuleParser.parse((Properties)serverProperties)) != null) {
            while (rulesParser.hasNextRule()) {
                rulesParser.nextRule();
                String dest = rulesParser.getCurrentDestination();
                JCoDestination rDest = JCoDestinationManager.getDestination((String)dest);
                IDocRepository repository = JCoIDocRepositoryManager.getIDocRepository(rDest);
                while (rulesParser.hasNextSystem()) {
                    this.setIDocRepositoryMappingRule(rulesParser.nextSystem(), repository);
                }
            }
        }
        if ((value = JCoRuntime.findProperty((String)"idoc.jco.server.usePartnerProfileRelease", (Properties)serverProperties)) == null || value.equals("0")) {
            this.usePartnerProfileRelease = false;
        } else if (value.equals("1")) {
            this.usePartnerProfileRelease = true;
        } else {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", new StringBuilder(132).append("The specified value \"").append(value).append("\" is invalid for the property \"").append("idoc.jco.server.usePartnerProfileRelease").append("\". Allowed values are \"0\" or \"1\".").toString());
        }
    }

    protected void updateOnChange(DefaultServer oldInstance) throws JCoException {
        super.updateOnChange(oldInstance);
        if (oldInstance instanceof DefaultJCoIDocServer) {
            DefaultJCoIDocServer jcoIDocOldInstance = (DefaultJCoIDocServer)oldInstance;
            this.idocHandlerFactory = jcoIDocOldInstance.idocHandlerFactory;
        }
    }

    public void setIDocRepository(IDocRepository idocRep) {
        if (this.idocRepositoryBox == null) {
            this.idocRepositoryBox = new DefaultServer.RepositoryBox((DefaultServer.IdProvider)new IDocRepositoryIdProvider());
        }
        this.idocRepositoryBox.setRepository((Object)idocRep);
    }

    public void setIDocRepository(String sid, String client, IDocRepository idocRepository) throws IDocRuntimeException {
        if (sid == null) {
            throw new IDocRuntimeException("sid equals null is not allowed in JCoIDocServer.setIDocRepository(sid, client, repository)");
        }
        if ((sid = sid.trim()).length() != 3) {
            throw new IDocRuntimeException("Illegal sid  [" + sid + "] is encountered in JCoIDocServer.setIDocRepository(sid, client, repository). sid should contain exactly 3 letters");
        }
        if (!(client == null || (client = client.trim()).length() == 3 && Character.isDigit(client.charAt(0)) && Character.isDigit(client.charAt(1)) && Character.isDigit(client.charAt(2)))) {
            throw new IDocRuntimeException("Illegal client  [" + client + "] is encountered in JCoIDocServer.setIDocRepository(sid, client, repository). client should contain exactly 3 numbers");
        }
        String key = sid;
        if (client != null) {
            key = key + "(" + client + ")";
        }
        this.setIDocRepositoryMappingRule(key, idocRepository);
    }

    private void setIDocRepositoryMappingRule(String key, IDocRepository idocRepository) {
        if (this.idocRepositoryBox == null) {
            this.idocRepositoryBox = new DefaultServer.RepositoryMapBox((DefaultServer.IdProvider)new IDocRepositoryIdProvider());
        }
        this.idocRepositoryBox = this.idocRepositoryBox.setRepository(key, (Object)idocRepository);
    }

    public IDocRepository getIDocRepository() {
        return (IDocRepository)this.idocRepositoryBox.getRepository();
    }

    public IDocRepository getIDocRepository(JCoServerContext serverCtx) {
        return (IDocRepository)this.idocRepositoryBox.getRepository((JCoServerContextInfo)serverCtx);
    }

    public void setIDocHandlerFactory(JCoIDocHandlerFactory idocHandlerFact) {
        this.idocHandlerFactory = idocHandlerFact;
    }

    public JCoIDocHandlerFactory getIDocHandlerFactory() {
        return this.idocHandlerFactory;
    }

    public void start() {
        if (this.idocHandlerFactory == null) {
            if (this.enforceIDocHandlerFactory) {
                throw new IDocRuntimeException("IDocHandlerFactory was not set, but this is required for an IDocServer");
            }
            this.idocHandlerFactory = new DefaultIDocHandlerFactory();
        }
        if (this.idocRepositoryBox == null || this.idocRepositoryBox.isEmpty()) {
            throw new IDocRuntimeException("IDocRepository was not set externally nor was one configured");
        }
        if (this.getCallHandlerFactory() == null) {
            this.setCallHandlerFactory((JCoServerCallHandlerFactory)new DefaultJCoIDocCallHandlerFactory());
        }
        super.start();
    }

    public void setEnforceIDocHandlerFactory(boolean enforceIDocHandlerFactory) {
        this.enforceIDocHandlerFactory = enforceIDocHandlerFactory;
    }

    protected DefaultServerWorker createServerWorkerInstance() {
        return new DefaultJCoIDocServerWorker(this);
    }

    boolean usesPartnerProfileRelease() {
        return this.usePartnerProfileRelease;
    }

    void refreshIDocRepository() throws JCoException {
        JCoDestination destination;
        String repositoryDestination = this.getRepositoryDestination();
        if (repositoryDestination != null && (destination = JCoDestinationManager.getDestination((String)repositoryDestination)) != null) {
            this.setIDocRepository(JCoIDocRepositoryManager.getIDocRepository(destination));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IDocRepositoryIdProvider
    implements DefaultServer.IdProvider<IDocRepository> {
        IDocRepositoryIdProvider() {
        }

        public String getID(IDocRepository rep) {
            return rep.getName();
        }
    }
}

