/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocQueueHandler;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.idoc.jco.JCoQueuedIDocHandler;
import com.sap.conn.idoc.jco.rt.DefaultJCoIDocServer;
import com.sap.conn.idoc.jco.rt.JCoIDocRuntime;
import com.sap.conn.idoc.jco.rt.RawTable;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.DefaultServerWorker;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;

class DefaultJCoIDocServerWorker
extends DefaultServerWorker {
    DefaultJCoIDocServerContext iDocServerContext = new DefaultJCoIDocServerContext();

    protected DefaultJCoIDocServerWorker(DefaultJCoIDocServer server) {
        super((DefaultServer)server);
        this.callDispatcher = new IDocDispatcher(server);
    }

    protected class IDocDispatcher
    extends DefaultServerWorker.CallDispatcher {
        private DefaultJCoIDocServer iDocServer;
        private IDocServerFunctionDispatcher functionDispatcher;
        private JCoIDocHandlerFactory iDocFactory;
        private JCoIDocHandler iDocHandler;

        IDocDispatcher(DefaultJCoIDocServer idocServer) {
            super((DefaultServerWorker)DefaultJCoIDocServerWorker.this, null);
            this.iDocServer = null;
            this.iDocServer = idocServer;
            JCoServerCallHandlerFactory callHandlerFactory = idocServer.getCallHandlerFactory();
            if (callHandlerFactory instanceof JCoServerFunctionHandlerFactory) {
                this.functionDispatcher = new FunctionDispatcherIDocServer((JCoServerFunctionHandlerFactory)callHandlerFactory);
            } else if (callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
                this.functionDispatcher = new RequestDispatcherIDocServer((JCoServerRequestHandlerFactory)callHandlerFactory);
            }
            this.iDocFactory = idocServer.getIDocHandlerFactory();
        }

        protected JCoFunction getFunction(JCoServerContext serverCtx, String functionName) throws JCoException {
            if (!("IDOC_INBOUND_IN_QUEUE".equals(functionName) || "IDOC_INBOUND_ASYNCHRONOUS".equals(functionName) || "INBOUND_IDOC_PROCESS".equals(functionName))) {
                this.iDocHandler = null;
                return this.iDocServer.getRepository((JCoServerContextInfo)serverCtx).getFunction(functionName);
            }
            DefaultJCoIDocServerWorker.this.iDocServerContext.setFunctionName(functionName);
            this.iDocHandler = this.iDocFactory.getIDocHandler(DefaultJCoIDocServerWorker.this.iDocServerContext);
            if (this.iDocHandler == null) {
                return this.iDocServer.getRepository((JCoServerContextInfo)serverCtx).getFunction(functionName);
            }
            return ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).getJCoFunction(functionName, serverCtx.getConnectionAttributes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            String functionName = function.getName();
            if (this.iDocHandler == null) {
                if (Trace.isOn(16)) {
                    StringBuilder buf = new StringBuilder(128).append("[IDocRFC] Redirecting request for " + functionName + " to call handler. Will not be processed as an IDoc");
                    Trace.fireTrace(16, buf.toString());
                }
                return this.functionDispatcher.handleRequest(serverCtx, function);
            }
            IDocDocumentList[] documentLists = null;
            try {
                documentLists = this.createIDocDocumentListArray(serverCtx, function, functionName);
            }
            catch (IDocRuntimeException ire) {
                Throwable cause = ire.getCause();
                if (cause instanceof JCoException && ((JCoException)cause).getGroup() == 180) {
                    if (Trace.isOn(16)) {
                        StringBuilder buf = new StringBuilder(128).append("[IDocRFC] Retrying the creation of the IDocDocumentList[] after invalid destination exception. Will try refreshing the IDocRepository");
                        Trace.fireTrace(16, buf.toString());
                    }
                    try {
                        this.iDocServer.refreshIDocRepository();
                        documentLists = this.createIDocDocumentListArray(serverCtx, function, functionName);
                    }
                    catch (Exception e) {
                        DefaultJCoIDocServerWorker.this.fireServerExceptionOccurred(e);
                        throw new IDocRuntimeException(e);
                    }
                }
                DefaultJCoIDocServerWorker.this.fireServerExceptionOccurred(ire);
                throw ire;
            }
            catch (RuntimeException re) {
                DefaultJCoIDocServerWorker.this.fireServerExceptionOccurred(re);
                throw re;
            }
            catch (IDocException exc) {
                DefaultJCoIDocServerWorker.this.fireServerExceptionOccurred(exc);
                throw new IDocRuntimeException(exc.getMessage(), exc);
            }
            catch (Error e) {
                DefaultJCoIDocServerWorker.this.fireServerErrorOccurred(e);
                throw e;
            }
            if (Trace.isOn(64)) {
                String iDocTypeExtension;
                IDocDocumentList documentList = null;
                StringBuilder buf = new StringBuilder(256).append("[IDocRFC] Processing an ");
                if (documentLists.length == 1) {
                    String systemRelease;
                    documentList = documentLists[0];
                    buf.append("IDocDocumentList of type ").append(documentList.getIDocType());
                    iDocTypeExtension = documentList.getIDocTypeExtension();
                    if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                        buf.append('|').append(iDocTypeExtension);
                    }
                    if ((systemRelease = documentList.getSystemRelease()) != null && systemRelease.length() > 0) {
                        buf.append(" and release ").append(systemRelease);
                        String applicationRelease = documentList.getApplicationRelease();
                        if (applicationRelease != null && applicationRelease.length() > 0) {
                            buf.append('|').append(applicationRelease);
                        }
                    }
                    if (documentList.getNumDocuments() == 1) {
                        buf.append(" containing a single document with ").append(documentList.get(0).getNumSegments()).append(" segments");
                    } else {
                        buf.append(" containing ").append(documentList.getNumDocuments()).append(" documents");
                    }
                } else {
                    buf.append("IDoc package with multiple types: ");
                    iDocTypeExtension = null;
                    String systemRelease = null;
                    String applicationRelease = null;
                    for (int i = 0; i < documentLists.length; ++i) {
                        documentList = documentLists[i];
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(documentList.getNumDocuments()).append("x ").append(documentList.getIDocType());
                        iDocTypeExtension = documentList.getIDocTypeExtension();
                        if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                            buf.append('|').append(iDocTypeExtension);
                        }
                        if ((systemRelease = documentList.getSystemRelease()) == null || systemRelease.length() <= 0) continue;
                        buf.append(" (").append(systemRelease);
                        applicationRelease = documentList.getApplicationRelease();
                        if (applicationRelease != null && applicationRelease.length() > 0) {
                            buf.append('|').append(applicationRelease);
                        }
                        buf.append(')');
                    }
                }
                Trace.fireTrace(64, buf.toString());
            }
            try {
                JCoParameterList importParameterList;
                if (this.iDocHandler instanceof JCoIDocQueueHandler) {
                    importParameterList = function.getImportParameterList();
                    if (importParameterList != null && importParameterList.getMetaData().getFieldCount() > 0) {
                        DefaultJCoIDocServerWorker.this.iDocServerContext.setIDocQueueName(importParameterList.getString(0));
                    }
                    ((JCoIDocQueueHandler)this.iDocHandler).handleRequest(DefaultJCoIDocServerWorker.this.iDocServerContext, documentLists);
                } else {
                    if (documentLists.length > 1) {
                        throw new IDocRuntimeException("The provided handler implementation cannot handle IDoc packages with multiple types. Make sure to implement a JCoIDocQueueHandler.");
                    }
                    if (this.iDocHandler instanceof JCoQueuedIDocHandler) {
                        importParameterList = function.getImportParameterList();
                        if (importParameterList != null && importParameterList.getMetaData().getFieldCount() > 0) {
                            DefaultJCoIDocServerWorker.this.iDocServerContext.setIDocQueueName(importParameterList.getString(0));
                        }
                        ((JCoQueuedIDocHandler)this.iDocHandler).handleRequest(DefaultJCoIDocServerWorker.this.iDocServerContext, documentLists[0]);
                    } else {
                        this.iDocHandler.handleRequest(serverCtx, documentLists[0]);
                    }
                }
            }
            finally {
                DefaultJCoIDocServerWorker.this.iDocServerContext.reset();
            }
            return this.iDocHandler;
        }

        private IDocDocumentList[] createIDocDocumentListArray(JCoServerContext serverCtx, JCoFunction function, String functionName) throws IDocException {
            IDocDocumentList[] documentLists = null;
            IDocRepository idocRepository = this.iDocServer.getIDocRepository(serverCtx);
            if ("IDOC_INBOUND_IN_QUEUE".equals(functionName)) {
                if (!(this.iDocHandler instanceof JCoIDocQueueHandler) && !(this.iDocHandler instanceof JCoQueuedIDocHandler)) {
                    throw new IDocException(8, "The provided handler implementation cannot handle queued IDocs properly. Make sure to implement a JCoIDocQueueHandler.");
                }
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_QUEUE");
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, true, null, this.iDocServer.usesPartnerProfileRelease());
            } else if ("IDOC_INBOUND_ASYNCHRONOUS".equals(functionName)) {
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_REC_40");
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, false, null, this.iDocServer.usesPartnerProfileRelease());
            } else if ("IDOC_INBOUND_IN_QUEUE_WITH_BINARY_DATA".equals(functionName)) {
                if (!(this.iDocHandler instanceof JCoIDocQueueHandler) && !(this.iDocHandler instanceof JCoQueuedIDocHandler)) {
                    throw new IDocException(8, "The provided handler implementation cannot handle queued IDocs properly. Make sure to implement a JCoIDocQueueHandler.");
                }
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_QUEUE");
                String codepage = serverCtx.getConnectionAttributes().getPartnerCodepage();
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, true, codepage, this.iDocServer.usesPartnerProfileRelease());
            } else if ("IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA".equals(functionName)) {
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_REC_40");
                String codepage = serverCtx.getConnectionAttributes().getPartnerCodepage();
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, false, codepage, this.iDocServer.usesPartnerProfileRelease());
            } else if ("INBOUND_IDOC_PROCESS".equals(functionName)) {
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA");
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, false, null, this.iDocServer.usesPartnerProfileRelease());
            } else if ("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA".equals(functionName)) {
                RawTable tabControl = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL");
                RawTable tabData = (RawTable)function.getTableParameterList().getTable("IDOC_DATA");
                String codepage = serverCtx.getConnectionAttributes().getPartnerCodepage();
                documentLists = ((JCoIDocRuntime)JCoIDoc.getIDocFactory()).createIDocDocumentListArray(idocRepository, tabControl, tabData, false, codepage, this.iDocServer.usesPartnerProfileRelease());
            } else {
                throw new IDocRuntimeException("IDocMessageHandler cannot dispatch function " + functionName);
            }
            return documentLists;
        }
    }

    protected class RequestDispatcherIDocServer
    extends DefaultServerWorker.RequestDispatcher
    implements IDocServerFunctionDispatcher {
        RequestDispatcherIDocServer(JCoServerRequestHandlerFactory factory) {
            super((DefaultServerWorker)DefaultJCoIDocServerWorker.this, factory);
        }

        public JCoServerRequestHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            return super.handleRequest(serverCtx, function);
        }
    }

    protected class FunctionDispatcherIDocServer
    extends DefaultServerWorker.FunctionDispatcher
    implements IDocServerFunctionDispatcher {
        FunctionDispatcherIDocServer(JCoServerFunctionHandlerFactory factory) {
            super((DefaultServerWorker)DefaultJCoIDocServerWorker.this, factory);
        }

        public JCoServerFunctionHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            return super.handleRequest(serverCtx, function);
        }
    }

    static interface IDocServerFunctionDispatcher {
        public Object handleRequest(JCoServerContext var1, JCoFunction var2) throws AbapException, AbapClassException;
    }

    class DefaultJCoIDocServerContext
    implements JCoIDocServerContext {
        private String iDocFunction;
        private char iDocVersion = (char)48;
        private String iDocQueueName;

        DefaultJCoIDocServerContext() {
        }

        public String getFunctionName() {
            return this.iDocFunction;
        }

        void setFunctionName(String idocFunction) {
            this.iDocFunction = idocFunction;
            this.iDocVersion = "IDOC_INBOUND_IN_QUEUE".equals(this.iDocFunction) ? (char)81 : ("IDOC_INBOUND_ASYNCHRONOUS".equals(this.iDocFunction) ? (char)51 : ("IDOC_INBOUND_PROCESS".equals(this.iDocFunction) ? (char)50 : (char)48));
        }

        public char getIDocVersion() {
            return this.iDocVersion;
        }

        public String getIDocQueueName() {
            return this.iDocQueueName;
        }

        void setIDocQueueName(String queueName) {
            this.iDocQueueName = queueName;
        }

        public JCoServerContext getJCoServerContext() {
            return DefaultJCoIDocServerWorker.this.ctx;
        }

        public IDocRepository getRepository() {
            DefaultJCoIDocServer server = (DefaultJCoIDocServer)DefaultJCoIDocServerWorker.this.getServer();
            return server.getIDocRepository((JCoServerContext)DefaultJCoIDocServerWorker.this.ctx);
        }

        void reset() {
            this.iDocFunction = null;
            this.iDocVersion = (char)48;
            this.iDocQueueName = null;
        }
    }
}

