/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocIllegalTypeException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.jco.rt.JCoIDocDocument;
import com.sap.conn.idoc.jco.rt.JCoIDocDocumentList;
import com.sap.conn.idoc.jco.rt.JCoIDocFunction;
import com.sap.conn.idoc.jco.rt.JCoIDocRepositoryManager;
import com.sap.conn.idoc.jco.rt.JCoStaticRepositories;
import com.sap.conn.idoc.jco.rt.JCoStaticRepository;
import com.sap.conn.idoc.jco.rt.RawTable;
import com.sap.conn.idoc.rt.DefaultIDocDocumentList;
import com.sap.conn.idoc.rt.DefaultIDocFieldMetaData;
import com.sap.conn.idoc.rt.DefaultIDocRecordMetaData;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.DefaultIDocSegmentMetaData;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.rt.ConnectionAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCoIDocRuntime
extends DefaultIDocRuntime {
    protected static JCoIDocRuntime get() {
        if (runtime == null) {
            DefaultIDocRuntime.get();
        }
        return (JCoIDocRuntime)runtime;
    }

    protected IDocRepository createRepository(JCoDestination destination) throws JCoException {
        return JCoIDocRepositoryManager.getIDocRepository(destination);
    }

    protected JCoIDocDocumentList[] createIDocDocumentListArray(IDocRepository repository, RawTable controlTable, RawTable dataTable, boolean dataTableContainsTypes, String binaryDataCharset, boolean usePartnerProfileRelease) throws IDocMetaDataUnavailableException {
        if (controlTable == null) {
            throw new IDocRuntimeException("mandatory parameter controlTable is missing");
        }
        if (dataTable == null) {
            throw new IDocRuntimeException("mandatory parameter dataTable is missing");
        }
        int numDocuments = controlTable.getNumRows();
        if (numDocuments < 1) {
            throw new IDocRuntimeException("passed controlTable has no rows");
        }
        ArrayList<DefaultIDocDocumentList> documentArrayList = new ArrayList<DefaultIDocDocumentList>(3);
        DefaultIDocDocumentList documentList = null;
        JCoIDocDocument document = null;
        IDocSegmentMetaData rootSegmentMetaData = null;
        int rowIndexDataTable = 0;
        try {
            for (int i = 0; i < numDocuments; ++i) {
                document = JCoIDocDocument.createIDocDocument(repository, controlTable, i, dataTable, rowIndexDataTable, dataTableContainsTypes, binaryDataCharset, usePartnerProfileRelease);
                rowIndexDataTable += document.getNumSegments() - 1;
                if (documentList == null || !documentList.isCompatible(document)) {
                    rootSegmentMetaData = document.getRootSegment().getSegmentMetaData();
                    documentList = new JCoIDocDocumentList(document.getTableStructureName(), repository, rootSegmentMetaData.getIDocType(), rootSegmentMetaData.getIDocTypeExtension(), rootSegmentMetaData.getSystemRelease(), rootSegmentMetaData.getApplicationRelease());
                    documentList.ensureCapacity(numDocuments - i);
                    documentArrayList.add(documentList);
                }
                documentList.add(document);
            }
        }
        catch (IDocIllegalTypeException ite) {
            throw new IDocRuntimeException(ite);
        }
        return documentArrayList.toArray(new JCoIDocDocumentList[documentArrayList.size()]);
    }

    @Override
    public JCoIDocDocument createIDocDocument(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        return new JCoIDocDocument(repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    @Override
    public JCoIDocDocument createIDocDocument(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        return new JCoIDocDocument(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    @Override
    public JCoIDocDocumentList createIDocDocumentList(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        return new JCoIDocDocumentList(repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    @Override
    public JCoIDocDocumentList createIDocDocumentList(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        return new JCoIDocDocumentList(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    @Override
    protected DefaultIDocFieldMetaData createIDocFieldMetaData(String fieldName, int internalLength, int outputLength, String dataTypeName, String dataElementName, String domainName, String description, String checkTableName, boolean isISOCode) {
        return super.createIDocFieldMetaData(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, checkTableName, isISOCode);
    }

    @Override
    protected DefaultIDocRecordMetaData createIDocRecordMetaData(String segmentName) {
        return super.createIDocRecordMetaData(segmentName);
    }

    @Override
    protected DefaultIDocSegmentMetaData createIDocRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, int hierarchyLevel, String description) {
        return super.createIDocRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, type, hierarchyLevel, description);
    }

    @Override
    protected DefaultIDocSegmentMetaData createIDocSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, boolean mandatoryFlag, long minOccurrence, long maxOccurrence, boolean qualifiedFlag, DefaultIDocRecordMetaData recordMetaData) {
        return super.createIDocSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, type, definition, hierarchyLevel, description, mandatoryFlag, minOccurrence, maxOccurrence, qualifiedFlag, recordMetaData);
    }

    protected JCoFunction createJCoFunction(IDocDocument doc, char iDocVersion, int options, JCoAttributes attributes, String qname) {
        return JCoIDocDocument.createJCoFunction(doc, iDocVersion, options, attributes, qname);
    }

    protected JCoFunction createJCoFunction(IDocDocumentList docList, char iDocVersion, int options, JCoAttributes attributes, String qname) {
        return JCoIDocDocumentList.createJCoFunction(docList, iDocVersion, options, attributes, qname);
    }

    protected JCoFunction getJCoFunction(String functionName, JCoAttributes attributes) {
        JCoStaticRepository jcoStaticRepository;
        String partnerCodepage = "1100";
        String partnerRelease = null;
        int ownBytesPerChar = 1;
        if (attributes != null) {
            partnerCodepage = attributes.getPartnerCodepage();
            partnerRelease = attributes.getPartnerRelease();
            ownBytesPerChar = ((ConnectionAttributes)attributes).getOwnBytesPerChar();
        }
        boolean isUnicode = JCoStaticRepositories.isPartnerSystemUnicode(partnerCodepage);
        if (Trace.isOn(128)) {
            String sysID = attributes != null ? attributes.getSystemID() : "unknown";
            String client = attributes != null ? attributes.getSystemID() : "XXX";
            Trace.fireTrace(128, new StringBuilder(128).append("[IDocRFC] Received an IDoc via ").append(functionName).append(" from system ").append(sysID).append(" with release ").append(partnerRelease).append(" out of client ").append(client).append(". Partner uses codepage " + partnerCodepage).toString());
        }
        if (("IDOC_INBOUND_IN_QUEUE".equals(functionName) || "IDOC_INBOUND_ASYNCHRONOUS".equals(functionName) || "INBOUND_IDOC_PROCESS".equals(functionName)) && (jcoStaticRepository = JCoStaticRepositories.getJCoStaticRepository(partnerRelease)) != null) {
            JCoFunction function = null;
            try {
                if (isUnicode || ownBytesPerChar <= 1) {
                    JCoFunctionTemplate functionTemplate = jcoStaticRepository.getFunctionTemplate(functionName);
                    if (functionTemplate != null) {
                        function = JCoIDocFunction.createFunction(functionName, functionTemplate);
                    }
                } else {
                    String binaryFunctionName;
                    JCoFunctionTemplate functionTemplate;
                    if (Trace.isOn(16)) {
                        Trace.fireTrace(16, new StringBuilder(128).append("[IDocRFC] Faking binary metadata in server. Will do conversion for codepage " + partnerCodepage + " in IDocLibrary").toString());
                    }
                    if ((functionTemplate = jcoStaticRepository.getFunctionTemplate(binaryFunctionName = functionName + "_WITH_BINARY_DATA")) != null) {
                        function = JCoIDocFunction.createFunction(binaryFunctionName, functionTemplate);
                    }
                }
            }
            catch (JCoException je) {
                // empty catch block
            }
            return function;
        }
        return null;
    }

    @Override
    public List<String> getRepositoryIDs() {
        return Arrays.asList(JCoIDocRepositoryManager.getRepositoryNames());
    }

    @Override
    public IDocRepository getRepository(String repositoryID) throws IDocRuntimeException {
        return JCoIDocRepositoryManager.getRepository(repositoryID);
    }
}

