/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocElementException;
import com.sap.conn.idoc.IDocIllegalTypeException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.rt.BasicDocumentList;
import com.sap.conn.idoc.rt.DefaultIDocDocument;
import com.sap.conn.idoc.rt.DefaultIDocSegment;
import com.sap.conn.idoc.rt.util.Utils;
import java.util.Date;

public class DefaultIDocDocumentList
extends BasicDocumentList {
    static final long serialVersionUID = 1000L;
    protected String m_controlStructName = null;
    protected int m_controlStructVersion = 0;
    protected String m_iDocType = null;
    protected String m_iDocTypeExtension = null;
    protected String m_systemRelease = null;
    protected String m_applicationRelease = null;
    IDocSegmentMetaData repSegmentMetaData = null;
    String m_iDocCompoundType = null;

    protected DefaultIDocDocumentList(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        this(null, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    protected DefaultIDocDocumentList(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        if (repository == null) {
            throw new NullPointerException("repository == null");
        }
        this.repSegmentMetaData = repository.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        if (this.repSegmentMetaData == null) {
            throw new IDocMetaDataUnavailableException("The meta data for the IDoc type \"" + iDocType + "\" " + (iDocTypeExtension != null && iDocTypeExtension.length() > 0 ? "with extension \"" + iDocTypeExtension + "\" " : "") + (systemRelease != null && systemRelease.length() > 0 ? "for system release \"" + systemRelease + "\" " : "") + (applicationRelease != null && applicationRelease.length() > 0 ? "and application release \"" + applicationRelease + "\" " : "") + "is unavailable.");
        }
        this.m_iDocType = this.repSegmentMetaData.getIDocType();
        this.m_iDocTypeExtension = this.repSegmentMetaData.getIDocTypeExtension();
        this.m_systemRelease = this.repSegmentMetaData.getSystemRelease();
        this.m_applicationRelease = this.repSegmentMetaData.getApplicationRelease();
        if (controlStructName != null && controlStructName.length() > 0) {
            this.m_controlStructName = controlStructName;
        } else {
            String string = this.m_systemRelease != null && this.m_systemRelease.length() > 0 ? (Utils.removeAllDotsFromString(this.m_systemRelease).compareTo("4") >= 0 ? "EDI_DC40" : "EDI_DC") : (this.m_controlStructName = "EDI_DC40");
        }
        if ("EDI_DC40".equals(this.m_controlStructName)) {
            this.m_controlStructVersion = 40;
        } else if ("EDI_DC".equals(this.m_controlStructName)) {
            this.m_controlStructVersion = 31;
        }
        if (this.m_controlStructVersion == 31 || this.m_systemRelease != null && this.m_systemRelease.length() > 0 && this.m_systemRelease.compareTo("4") < 0) {
            this.m_iDocCompoundType = repository.getIDocCompoundType(this.m_iDocType, this.m_iDocTypeExtension);
        }
    }

    public boolean add(IDocDocument document) throws IDocIllegalTypeException {
        if (!this.isCompatible(document)) {
            IDocSegmentMetaData rootSegmentMetaData = null;
            IDocSegment rootSegment = document.getRootSegment();
            if (rootSegment != null) {
                rootSegmentMetaData = rootSegment.getSegmentMetaData();
            }
            if (rootSegmentMetaData == null || this.m_iDocType != null && !this.m_iDocType.equals(rootSegmentMetaData.getIDocType()) || this.m_iDocType == null && rootSegmentMetaData.getIDocType() != null || this.m_iDocTypeExtension != null && !this.m_iDocTypeExtension.equals(rootSegmentMetaData.getIDocTypeExtension()) || this.m_iDocTypeExtension == null && rootSegmentMetaData.getIDocTypeExtension() != null || this.m_systemRelease != null && !this.m_systemRelease.equals(rootSegmentMetaData.getSystemRelease()) || this.m_systemRelease == null && rootSegmentMetaData.getSystemRelease() != null || this.m_applicationRelease != null && !this.m_applicationRelease.equals(rootSegmentMetaData.getApplicationRelease()) || this.m_applicationRelease == null && rootSegmentMetaData.getApplicationRelease() != null) {
                StringBuilder errMsg = new StringBuilder(300);
                errMsg.append("document is not compatible with the document list: the document to add ");
                if (rootSegmentMetaData != null) {
                    errMsg.append("is of type ").append(rootSegmentMetaData.getIDocType());
                    if (rootSegmentMetaData.getIDocTypeExtension() != null && rootSegmentMetaData.getIDocTypeExtension().length() > 0) {
                        errMsg.append('|').append(rootSegmentMetaData.getIDocTypeExtension());
                    }
                    if (rootSegmentMetaData.getSystemRelease() != null && rootSegmentMetaData.getSystemRelease().length() > 0) {
                        errMsg.append('|').append(rootSegmentMetaData.getSystemRelease());
                    }
                    if (rootSegmentMetaData.getApplicationRelease() != null && rootSegmentMetaData.getApplicationRelease().length() > 0) {
                        errMsg.append('|').append(rootSegmentMetaData.getApplicationRelease());
                    }
                } else {
                    errMsg.append("does not have any meta data");
                }
                errMsg.append(", but the document list can only store documents of type ");
                errMsg.append(this.m_iDocType);
                if (this.m_iDocTypeExtension != null && this.m_iDocTypeExtension.length() > 0) {
                    errMsg.append('|').append(this.m_iDocTypeExtension);
                }
                if (this.m_systemRelease != null && this.m_systemRelease.length() > 0) {
                    errMsg.append('|').append(this.m_systemRelease);
                }
                if (this.m_applicationRelease != null && this.m_applicationRelease.length() > 0) {
                    errMsg.append('|').append(this.m_applicationRelease);
                }
                throw new IDocIllegalTypeException(document, errMsg.toString());
            }
            throw new IDocIllegalTypeException(document, "document is not compatible with the document list's associated repository");
        }
        return this.m_list.add(document);
    }

    public IDocDocument addNew() throws IDocMetaDataUnavailableException {
        DefaultIDocDocument document = this.createDefaultIDocDocument(this.m_controlStructName);
        document.m_rootSegment = this.createDefaultIDocSegment(document, this.repSegmentMetaData, false);
        try {
            document.setIDocType(this.m_iDocType);
            document.setIDocTypeExtension(this.m_iDocTypeExtension);
            if (document.m_controlStructVersion == 31 || this.m_systemRelease != null && this.m_systemRelease.length() > 0 && this.m_systemRelease.compareTo("4") < 0) {
                document.setIDocCompoundType(this.m_iDocCompoundType);
            }
            Date timestamp = new Date();
            document.setCreationDate(timestamp);
            document.setCreationTime(timestamp);
            this.m_list.add(document);
        }
        catch (IDocElementException e) {
            throw new IDocMetaDataUnavailableException(e.getMessage(), e);
        }
        return document;
    }

    protected DefaultIDocDocument createDefaultIDocDocument(String controlStructName) {
        return new DefaultIDocDocument(this.m_controlStructName);
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new DefaultIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }

    public String getApplicationRelease() {
        return this.m_applicationRelease;
    }

    public String getIDocType() {
        return this.m_iDocType;
    }

    public String getIDocTypeExtension() {
        return this.m_iDocTypeExtension;
    }

    public String getSystemRelease() {
        return this.m_systemRelease;
    }

    public boolean isCompatible(IDocDocument document) {
        if (document == null) {
            throw new NullPointerException("document == null");
        }
        IDocSegmentMetaData rootSegmentMetaData = null;
        IDocSegment rootSegment = document.getRootSegment();
        if (rootSegment != null) {
            rootSegmentMetaData = rootSegment.getSegmentMetaData();
        }
        return this.repSegmentMetaData.equals(rootSegmentMetaData);
    }

    public String toString() {
        StringBuilder strBld = new StringBuilder(1000);
        strBld.append("document list {IDocType = ").append(this.getIDocType());
        strBld.append(", IDocTypeExtension = ").append(this.getIDocTypeExtension());
        strBld.append(", SystemRelease = ").append(this.getSystemRelease());
        strBld.append(", ApplicationRelease = ").append(this.getApplicationRelease());
        int numDocs = this.getNumDocuments();
        strBld.append("}\ncontains ").append(numDocs).append(" document");
        if (numDocs != 1) {
            strBld.append('s');
        }
        if (numDocs > 0) {
            strBld.append(':');
        }
        IDocDocument doc = this.first();
        while (doc != null) {
            strBld.append('\n');
            strBld.append(doc.toString());
            doc = this.getNext(doc);
        }
        return strBld.toString();
    }
}

