/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocIllegalTypeException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentIterator;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.rt.BasicIDocRecord;
import com.sap.conn.idoc.rt.DefaultIDocSegmentList;
import com.sap.conn.idoc.rt.SegmentIterator;
import com.sap.conn.idoc.rt.cp.I18NConverters;
import com.sap.conn.idoc.rt.util.Int;
import com.sap.conn.idoc.rt.util.Utils;
import com.sap.i18n.cp.ConvertXToC;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class DefaultIDocSegment
extends BasicIDocRecord
implements IDocSegment,
Cloneable {
    private static final long serialVersionUID = 1000L;
    protected IDocDocument m_document = null;
    protected DefaultIDocSegment m_parent = null;
    protected IDocSegmentMetaData m_segmentMetaData = null;
    protected DefaultIDocSegmentList m_childs = new DefaultIDocSegmentList(5);
    protected Hashtable<String, Int> m_childSegmentTypeCounters = new Hashtable(5);

    protected DefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        super(8, segmentMetaData.getRecordMetaData());
        this.m_document = document;
        this.m_segmentMetaData = segmentMetaData;
        this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
        char[] dataBuffer = this.getRawBuffer();
        for (int i = 0; i < dataBuffer.length; ++i) {
            dataBuffer[i] = 32;
        }
    }

    protected DefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, byte[] sData, String sDataCharset) throws IDocConversionException, IDocSyntaxException {
        super(8, segmentMetaData.getRecordMetaData());
        this.m_document = document;
        this.m_segmentMetaData = segmentMetaData;
        this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
        int numFields = this.recordMetaData.getNumFields();
        if (sDataCharset == null) {
            sDataCharset = Utils.getSystemDefaultCharEncoding();
        }
        if (!sDataCharset.equals(Utils.getSystemDefaultCharEncoding())) {
            ConvertXToC converter = I18NConverters.getConvertXToC(sDataCharset);
            if (converter != null) {
                char[] value = null;
                for (int i = 0; i < numFields; ++i) {
                    int offset = this.recordMetaData.getOffset(i);
                    int length = this.recordMetaData.getOutputLength(i);
                    value = converter.ConvertArr(sData, offset, offset + length);
                    this.setValueWithoutCheck(i, new String(value));
                }
                return;
            }
            try {
                String value = null;
                for (int i = 0; i < numFields; ++i) {
                    int offset = this.recordMetaData.getOffset(i);
                    int length = this.recordMetaData.getOutputLength(i);
                    value = new String(sData, offset, length, sDataCharset);
                    this.setValueWithoutCheck(i, value);
                }
                return;
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        String value = null;
        for (int i = 0; i < numFields; ++i) {
            int offset = this.recordMetaData.getOffset(i);
            int length = this.recordMetaData.getOutputLength(i);
            value = new String(sData, offset, length);
            this.setValueWithoutCheck(i, value);
        }
    }

    protected DefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, String sData) {
        super(8, segmentMetaData.getRecordMetaData());
        this.m_document = document;
        this.m_segmentMetaData = segmentMetaData;
        this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
        char[] dataBuffer = this.getRawBuffer();
        int len = Math.min(sData.length(), dataBuffer.length);
        sData.getChars(0, len, dataBuffer, 0);
        for (int i = len; i < dataBuffer.length; ++i) {
            dataBuffer[i] = 32;
        }
    }

    public IDocSegment addChild(String segmentType) throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        return this.addChild(segmentType, true);
    }

    public IDocSegment addChild(String segmentType, boolean subsequent) throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        if (segmentType == null) {
            throw new NullPointerException("segmentType == null");
        }
        if (segmentType.length() == 0) {
            throw new IDocIllegalTypeException(this, "Segment type \"\" is not a valid child segment type.");
        }
        DefaultIDocSegment child = null;
        IDocSegmentMetaData childMetaData = null;
        IDocSegment sibling = null;
        sibling = subsequent ? this.getLastChild(segmentType) : this.getFirstChild(segmentType);
        if (sibling != null) {
            childMetaData = sibling.getSegmentMetaData();
            if (childMetaData == null) {
                throw new IDocMetaDataUnavailableException("The meta data of the adjectant sibling segment is unavailable.");
            }
        } else {
            IDocSegmentMetaData myMetaData = this.getSegmentMetaData();
            if (myMetaData == null) {
                throw new IDocMetaDataUnavailableException("The meta data of this segment is unavailable.");
            }
            childMetaData = myMetaData.getChildByType(segmentType);
            int index = myMetaData.indexOfChild(childMetaData);
            while (sibling == null && index > 0) {
                sibling = this.getLastChild(myMetaData.getChild(--index).getType());
            }
            subsequent = sibling != null;
        }
        if (childMetaData != null) {
            child = this.createDefaultIDocSegment(this.m_document, childMetaData, this.m_checkFieldValuesOnSet);
            if (sibling != null) {
                if (subsequent) {
                    this.m_childs.addAfter(sibling, child);
                } else {
                    this.m_childs.addBefore(sibling, child);
                }
            } else if (subsequent) {
                this.m_childs.add(child);
            } else {
                this.m_childs.add(0, child);
            }
            child.m_parent = this;
            Int counter = this.m_childSegmentTypeCounters.get(segmentType);
            if (counter != null) {
                counter.increment();
            } else {
                this.m_childSegmentTypeCounters.put(segmentType, new Int(1));
            }
        } else {
            throw new IDocIllegalTypeException(this, "Segment type \"" + segmentType + "\" is not a valid child segment type.");
        }
        return child;
    }

    protected void addChild(DefaultIDocSegment child) {
        this.m_childs.add(child);
        child.m_parent = this;
        child.m_document = this.m_document;
        String childSegmentType = child.getType();
        Int counter = this.m_childSegmentTypeCounters.get(childSegmentType);
        if (counter != null) {
            counter.increment();
        } else {
            this.m_childSegmentTypeCounters.put(childSegmentType, new Int(1));
        }
    }

    public IDocSegment addSibling() throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        return this.addSibling(true);
    }

    public IDocSegment addSibling(boolean subsequent) throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        if (this.m_parent == null) {
            throw new IDocIllegalTypeException(this, "A root segment is not allowed to have sibling segments.");
        }
        IDocSegmentMetaData myMetaData = this.getSegmentMetaData();
        if (myMetaData == null) {
            throw new IDocMetaDataUnavailableException("The meta data of this segment is unavailable.");
        }
        String mySegmentType = myMetaData.getType();
        DefaultIDocSegment sibling = this.createDefaultIDocSegment(this.m_document, myMetaData, this.m_checkFieldValuesOnSet);
        if (subsequent) {
            IDocSegment predecessor = this.m_parent.getLastChild(mySegmentType);
            this.m_parent.m_childs.addAfter(predecessor, sibling);
        } else {
            IDocSegment successor = this.m_parent.getFirstChild(mySegmentType);
            this.m_parent.m_childs.addBefore(successor, sibling);
        }
        sibling.m_parent = this.m_parent;
        Int counter = this.m_parent.m_childSegmentTypeCounters.get(mySegmentType);
        if (counter != null) {
            counter.increment();
        } else {
            this.m_parent.m_childSegmentTypeCounters.put(mySegmentType, new Int(1));
        }
        return sibling;
    }

    public IDocSegment addSibling(String segmentType) throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        if (this.m_parent == null) {
            throw new IDocIllegalTypeException(this, "A root segment is not allowed to have sibling segments.");
        }
        if (segmentType == null) {
            throw new NullPointerException("segmentType == null");
        }
        if (segmentType.length() == 0) {
            throw new IDocIllegalTypeException(this, "Segment type \"\" is not a valid sibling segment type.");
        }
        if (segmentType.equals(this.getType())) {
            return this.addSibling(true);
        }
        return this.m_parent.addChild(segmentType, true);
    }

    public IDocSegment addSibling(String segmentType, boolean subsequent) throws IDocMetaDataUnavailableException, IDocIllegalTypeException {
        if (this.m_parent == null) {
            throw new IDocIllegalTypeException(this, "A root segment is not allowed to have sibling segments.");
        }
        if (segmentType == null) {
            throw new NullPointerException("segmentType == null");
        }
        if (segmentType.length() == 0) {
            throw new IDocIllegalTypeException(this, "Segment type \"\" is not a valid sibling segment type.");
        }
        if (segmentType.equals(this.getType())) {
            return this.addSibling(subsequent);
        }
        return this.m_parent.addChild(segmentType, subsequent);
    }

    public void checkChildSegmentsOccurrenceLimits() throws IDocSyntaxException {
        if (this.m_childs.size() == 0) {
            return;
        }
        IDocSegmentMetaData segmentMetaData = null;
        IDocSegmentMetaData lastSegmentMetaData = null;
        String segmentType = null;
        int numSegments = 0;
        IDocSegment[] childs = this.m_childs.toArray();
        for (int i = 0; i < childs.length; ++i) {
            segmentMetaData = childs[i].getSegmentMetaData();
            if (segmentMetaData == lastSegmentMetaData) continue;
            segmentType = segmentMetaData.getType();
            numSegments = this.getNumChildren(segmentType);
            if ((long)numSegments < segmentMetaData.getMinOccurrence()) {
                throw new IDocSyntaxException(childs[i], "Minimum number of segments not reached: " + segmentType);
            }
            if ((long)numSegments > segmentMetaData.getMaxOccurrence()) {
                throw new IDocSyntaxException(childs[i], "Maximum number of segments exceeded: " + segmentType);
            }
            lastSegmentMetaData = segmentMetaData;
        }
    }

    public void checkMandatoryChildSegments() throws IDocMetaDataUnavailableException, IDocSyntaxException {
        IDocSegmentMetaData mySegmentMetaData = this.getSegmentMetaData();
        if (mySegmentMetaData == null) {
            throw new IDocMetaDataUnavailableException("Meta data for this segment is unavailable.");
        }
        if (mySegmentMetaData.getNumChildren() == 0) {
            return;
        }
        String segmentType = null;
        IDocSegmentMetaData[] childs = mySegmentMetaData.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            if (!childs[i].isMandatory() || this.getNumChildren(segmentType = childs[i].getType()) != 0) continue;
            throw new IDocSyntaxException(this, "Missing mandatory segment: " + segmentType);
        }
    }

    public void checkSyntax() throws IDocMetaDataUnavailableException, IDocSyntaxException {
        this.checkSyntax(524);
    }

    public void checkSyntax(int options) throws IDocMetaDataUnavailableException, IDocSyntaxException {
        if ((options & 0x200) != 0) {
            this.checkFieldValues();
        }
        if ((options & 4) != 0) {
            this.checkMandatoryChildSegments();
        }
        if ((options & 8) != 0) {
            this.checkChildSegmentsOccurrenceLimits();
        }
        if ((options & 0x10000) == 0) {
            int numChilds = this.m_childs.size();
            for (int i = 0; i < numChilds; ++i) {
                this.m_childs.get(i).checkSyntax(options);
            }
        }
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new DefaultIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }

    public void disableFieldValueChecking() {
        this.disableFieldValueChecking(true);
    }

    public void disableFieldValueChecking(boolean applyToChildren) {
        this.m_checkFieldValuesOnSet = false;
        if (applyToChildren) {
            int numChildren = this.m_childs.size();
            for (int i = 0; i < numChildren; ++i) {
                this.m_childs.get(i).disableFieldValueChecking(true);
            }
        }
    }

    public void enableFieldValueChecking() {
        this.enableFieldValueChecking(true);
    }

    public void enableFieldValueChecking(boolean applyToChildren) {
        this.m_checkFieldValuesOnSet = true;
        if (applyToChildren) {
            int numChildren = this.m_childs.size();
            for (int i = 0; i < numChildren; ++i) {
                this.m_childs.get(i).enableFieldValueChecking(true);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IDocSegment)) {
            return false;
        }
        return super.equals(object);
    }

    public IDocSegment getChild(int index) {
        return this.m_childs.get(index);
    }

    public IDocSegment[] getChildren() {
        return this.m_childs.toArray();
    }

    public IDocSegment[] getChildren(String segmentType) {
        if (segmentType == null || this.m_childs.isEmpty()) {
            return new IDocSegment[0];
        }
        DefaultIDocSegmentList childs = new DefaultIDocSegmentList(this.m_childs.size());
        IDocSegment segment = this.getFirstChild(segmentType);
        if (segment != null) {
            do {
                childs.add(segment);
            } while ((segment = segment.getNextSibling(segmentType)) != null);
        }
        return childs.toArray();
    }

    public IDocSegmentIterator getChildrenIterator() {
        return new SegmentIterator(this, 5);
    }

    public IDocSegmentIterator getChildrenIterator(String segmentType) {
        return new SegmentIterator(this, 5, segmentType);
    }

    public String getDefinition() {
        if (this.m_segmentMetaData == null) {
            return null;
        }
        return this.m_segmentMetaData.getDefinition();
    }

    public IDocSegmentIterator getDescendantsIterator() {
        return new SegmentIterator(this, 6);
    }

    public String getDescription() {
        if (this.m_segmentMetaData == null) {
            return null;
        }
        return this.m_segmentMetaData.getDescription();
    }

    public IDocDocument getDocument() {
        return this.m_document;
    }

    public IDocSegment getFirstChild() {
        return this.m_childs.first();
    }

    public IDocSegment getFirstChild(String segmentType) {
        if (segmentType == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        while (segment != null && !segmentType.equals(segment.getType())) {
            segment = this.m_childs.getNext(segment);
        }
        return segment;
    }

    public IDocSegment getFirstChild(String segmentType, int fieldIndex, String fieldValue) {
        if (segmentType == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
            segment = this.m_childs.getNext(segment);
        }
        return segment;
    }

    public IDocSegment getFirstChild(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        if (segmentType == null || fieldName == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
            segment = this.m_childs.getNext(segment);
        }
        return segment;
    }

    public IDocSegment getFirstDescendant(String segmentType) {
        if (this.m_childs.isEmpty() || segmentType == null) {
            return null;
        }
        IDocSegment segment = this.getFirstChild(segmentType);
        if (segment == null) {
            IDocSegment descendant = null;
            IDocSegment child = this.m_childs.first();
            int childLevel = child.getHierarchyLevel();
            int segmentLevel = Integer.MAX_VALUE;
            while (child != null) {
                descendant = child.getFirstDescendant(segmentType);
                if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                    return segment;
                }
                child = this.m_childs.getNext(child);
            }
        }
        return segment;
    }

    public IDocSegment getFirstDescendant(String segmentType, int fieldIndex, String fieldValue) {
        if (this.m_childs.isEmpty() || segmentType == null) {
            return null;
        }
        IDocSegment segment = this.getFirstChild(segmentType, fieldIndex, fieldValue);
        if (segment == null) {
            IDocSegment descendant = null;
            IDocSegment child = this.m_childs.first();
            int childLevel = child.getHierarchyLevel();
            int segmentLevel = Integer.MAX_VALUE;
            while (child != null) {
                descendant = child.getFirstDescendant(segmentType, fieldIndex, fieldValue);
                if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                    return segment;
                }
                child = this.m_childs.getNext(child);
            }
        }
        return segment;
    }

    public IDocSegment getFirstDescendant(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        if (this.m_childs.isEmpty() || segmentType == null || fieldName == null) {
            return null;
        }
        IDocSegment segment = this.getFirstChild(segmentType, fieldName, fieldValue);
        if (segment == null) {
            IDocSegment descendant = null;
            IDocSegment child = this.m_childs.first();
            int childLevel = child.getHierarchyLevel();
            int segmentLevel = Integer.MAX_VALUE;
            while (child != null) {
                descendant = child.getFirstDescendant(segmentType, fieldName, fieldValue);
                if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                    return segment;
                }
                child = this.m_childs.getNext(child);
            }
        }
        return segment;
    }

    public int getHierarchyLevel() {
        if (this.m_segmentMetaData == null) {
            return -1;
        }
        return this.m_segmentMetaData.getHierarchyLevel();
    }

    public IDocSegment getLastChild() {
        return this.m_childs.last();
    }

    public IDocSegment getLastChild(String segmentType) {
        if (segmentType == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.last();
        while (segment != null && !segmentType.equals(segment.getType())) {
            segment = this.m_childs.getPrevious(segment);
        }
        return segment;
    }

    public IDocSegment getLastChild(String segmentType, int fieldIndex, String fieldValue) {
        if (segmentType == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.last();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
            segment = this.m_childs.getPrevious(segment);
        }
        return segment;
    }

    public IDocSegment getLastChild(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        if (segmentType == null || fieldName == null || this.getNumChildren(segmentType) == 0) {
            return null;
        }
        IDocSegment segment = this.m_childs.last();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
            segment = this.m_childs.getPrevious(segment);
        }
        return segment;
    }

    public IDocSegment getNext() {
        IDocSegment segment = null;
        if (this.m_childs.isEmpty()) {
            DefaultIDocSegment parent = this;
            do {
                segment = parent.getNextSibling();
                parent = parent.m_parent;
            } while (segment == null && parent != null);
        } else {
            segment = this.m_childs.first();
        }
        return segment;
    }

    public IDocSegment getNext(String segmentType) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getNext(); segment != null && !segmentType.equals(segment.getType()); segment = segment.getNext()) {
        }
        return segment;
    }

    public IDocSegment getNext(String segmentType, int fieldIndex, String fieldValue) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getNext(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue)); segment = segment.getNext()) {
        }
        return segment;
    }

    public IDocSegment getNext(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        IDocSegment segment;
        if (segmentType == null || fieldName == null) {
            return null;
        }
        for (segment = this.getNext(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue)); segment = segment.getNext()) {
        }
        return segment;
    }

    public IDocSegment getNextDescendant(String segmentType) {
        if (segmentType == null || this.m_childs.isEmpty()) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        int myLevel = this.getHierarchyLevel();
        while (segment != null && !segmentType.equals(segment.getType())) {
            if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
            return null;
        }
        return segment;
    }

    public IDocSegment getNextDescendant(String segmentType, int fieldIndex, String fieldValue) {
        if (segmentType == null || this.m_childs.isEmpty()) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        int myLevel = this.getHierarchyLevel();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
            if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
            return null;
        }
        return segment;
    }

    public IDocSegment getNextDescendant(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        if (segmentType == null || fieldName == null || this.m_childs.isEmpty()) {
            return null;
        }
        IDocSegment segment = this.m_childs.first();
        int myLevel = this.getHierarchyLevel();
        while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
            if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
            return null;
        }
        return segment;
    }

    public IDocSegment getNextSibling() {
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.m_childs.getNext(this);
    }

    public IDocSegment getNextSibling(String segmentType) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getNextSibling(); segment != null && !segmentType.equals(segment.getType()); segment = segment.getNextSibling()) {
        }
        return segment;
    }

    public IDocSegment getNextSibling(String segmentType, int fieldIndex, String fieldValue) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getNextSibling(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue)); segment = segment.getNextSibling()) {
        }
        return segment;
    }

    public IDocSegment getNextSibling(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        IDocSegment segment;
        if (segmentType == null || fieldName == null) {
            return null;
        }
        for (segment = this.getNextSibling(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue)); segment = segment.getNextSibling()) {
        }
        return segment;
    }

    public int getNumChildren() {
        return this.m_childs.size();
    }

    public int getNumChildren(String segmentType) {
        if (segmentType == null) {
            return 0;
        }
        Int counter = this.m_childSegmentTypeCounters.get(segmentType);
        if (counter != null) {
            return counter.value();
        }
        return 0;
    }

    public int getNumDescendants() {
        int numDescendants = this.m_childs.size();
        if (numDescendants > 0) {
            IDocSegment[] childs = this.m_childs.toArray();
            for (int i = 0; i < childs.length; ++i) {
                numDescendants += childs[i].getNumDescendants();
            }
        }
        return numDescendants;
    }

    public int getNumDescendants(String segmentType) {
        int numDescendants = 0;
        if (this.m_childs.size() > 0) {
            numDescendants = this.getNumChildren(segmentType);
            IDocSegment[] childs = this.m_childs.toArray();
            for (int i = 0; i < childs.length; ++i) {
                numDescendants += childs[i].getNumDescendants(segmentType);
            }
        }
        return numDescendants;
    }

    public IDocSegment getParent() {
        return this.m_parent;
    }

    public IDocSegment getPrevious() {
        IDocSegment segment = this.getPreviousSibling();
        if (segment == null) {
            segment = this.m_parent;
        } else {
            while (segment.getNumChildren() > 0) {
                segment = segment.getLastChild();
            }
        }
        return segment;
    }

    public IDocSegment getPrevious(String segmentType) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getPrevious(); segment != null && !segmentType.equals(segment.getType()); segment = segment.getPrevious()) {
        }
        return segment;
    }

    public IDocSegment getPrevious(String segmentType, int fieldIndex, String fieldValue) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getPrevious(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue)); segment = segment.getPrevious()) {
        }
        return segment;
    }

    public IDocSegment getPrevious(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        IDocSegment segment;
        if (segmentType == null || fieldName == null) {
            return null;
        }
        for (segment = this.getPrevious(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue)); segment = segment.getPrevious()) {
        }
        return segment;
    }

    public IDocSegment getPreviousSibling() {
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.m_childs.getPrevious(this);
    }

    public IDocSegment getPreviousSibling(String segmentType) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getPreviousSibling(); segment != null && !segmentType.equals(segment.getType()); segment = segment.getPreviousSibling()) {
        }
        return segment;
    }

    public IDocSegment getPreviousSibling(String segmentType, int fieldIndex, String fieldValue) {
        IDocSegment segment;
        if (segmentType == null) {
            return null;
        }
        for (segment = this.getPreviousSibling(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue)); segment = segment.getPreviousSibling()) {
        }
        return segment;
    }

    public IDocSegment getPreviousSibling(String segmentType, String fieldName, String fieldValue) throws IDocFieldNotFoundException {
        IDocSegment segment;
        if (segmentType == null || fieldName == null) {
            return null;
        }
        for (segment = this.getPreviousSibling(); !(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue)); segment = segment.getPreviousSibling()) {
        }
        return segment;
    }

    public IDocSegmentMetaData getSegmentMetaData() {
        return this.m_segmentMetaData;
    }

    public String getType() {
        if (this.m_segmentMetaData == null) {
            return null;
        }
        return this.m_segmentMetaData.getType();
    }

    public int hashCode() {
        if (this.metaData.getName() == null) {
            return 0;
        }
        return this.metaData.getName().hashCode();
    }

    public boolean isChild() {
        return this.m_parent != null;
    }

    public boolean isLeaf() {
        return this.m_childs.isEmpty();
    }

    public boolean isParent() {
        return !this.m_childs.isEmpty();
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public boolean remove() {
        if (this.m_parent != null) {
            return this.m_parent.removeChild(this);
        }
        return false;
    }

    public boolean removeChild(IDocSegment child) {
        if (child == null || this.m_childs == null) {
            return false;
        }
        boolean removed = this.m_childs.remove(child);
        if (removed) {
            Int counter = this.m_childSegmentTypeCounters.get(child.getType());
            if (counter != null) {
                counter.decrement();
            }
            if (child instanceof DefaultIDocSegment) {
                ((DefaultIDocSegment)child).m_parent = null;
                ((DefaultIDocSegment)child).removeFromDocument();
            }
        }
        return removed;
    }

    protected void removeFromDocument() {
        this.m_document = null;
        IDocSegment[] childs = this.m_childs.toArray();
        for (int i = 0; i < childs.length; ++i) {
            if (!(childs[i] instanceof DefaultIDocSegment)) continue;
            ((DefaultIDocSegment)childs[i]).removeFromDocument();
        }
    }

    public String toString() {
        StringBuilder strBld = new StringBuilder(1000);
        strBld.append("Name = ");
        strBld.append(this.metaData.getName());
        strBld.append("\nType = ");
        strBld.append(this.getType());
        strBld.append("\nHierarchy Level = ");
        strBld.append(this.getHierarchyLevel());
        strBld.append("\nDefinition = ");
        strBld.append(this.getDefinition());
        strBld.append("\nDescription = ");
        strBld.append(this.getDescription());
        strBld.append('\n');
        strBld.append(super.toString());
        return strBld.toString();
    }
}

