/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocTraceListener;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.SyncDateFormat;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;

public class ErrorTrace
extends Trace
implements IDocTraceListener {
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private static final SyncDateFormat fileNameTimestampFormat = new SyncDateFormat("yyyyMMdd_HHmmss");
    private static int traceLevel = 1;
    private static Writer traceWriter = null;
    private static File traceFile = null;
    private static Object mutex = new Object();
    private static IDocTraceListener singleton = null;
    private static String traceFileName = "dev_idoc.trc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        traceLevel = System.getProperty("idoc.error_trace", "1").equals("1") ? 1 : 0;
        Object object = mutex;
        synchronized (object) {
            if (singleton == null) {
                singleton = new ErrorTrace();
            }
            Trace.addTracelistener(singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Writer getTraceWriter() {
        Object object = mutex;
        synchronized (object) {
            if (traceFile == null) {
                traceFile = new File(traceFileName);
                traceWriter = ErrorTrace.openFile(traceFile);
                this.writeInfo(singleton);
            }
        }
        return traceWriter;
    }

    private static Writer openFile(File file) {
        BufferedWriter writer = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
                fos.flush();
            }
            catch (UnsupportedEncodingException e) {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            }
            return writer;
        }
        catch (IOException ex) {
            throw new RuntimeException("IDocLibrary-TraceWriter: cannot open trace file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    protected void finalize() throws Throwable {
        if (traceWriter != null) {
            try {
                traceWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int level, String message) {
        if (level > traceLevel) {
            return;
        }
        try {
            Object object = mutex;
            synchronized (object) {
                if (traceFile != null && traceFile.length() > 0x1400000L) {
                    traceWriter.close();
                    String renameToName = new StringBuilder(50).append(traceFileName.substring(0, traceFileName.lastIndexOf(46))).append('.').append(fileNameTimestampFormat.format(new Date())).append(".trc").toString();
                    traceFile.renameTo(new File(renameToName));
                    traceWriter = ErrorTrace.openFile(traceFile);
                }
                traceWriter.write(Thread.currentThread().getName());
                traceWriter.write(" [");
                traceWriter.write(timeStamp.format(new Date()));
                traceWriter.write("]");
                traceWriter.write(": ");
                traceWriter.write(message);
                traceWriter.write(CRLF);
                traceWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getOwnFilePath() {
        return ErrorTrace.getFilePathToClass(DefaultIDocRuntime.get().getClass());
    }

    protected Properties getProperties() {
        return DefaultIDocRuntime.properties;
    }

    protected String getVersion() {
        return DefaultIDocRuntime.get().getVersion();
    }
}

