/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.xml;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocFactory;
import com.sap.conn.idoc.IDocParseException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocXMLFormat;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.rt.xml.DefaultIDocXMLParser;
import com.sap.conn.idoc.rt.xml.DefaultIDocXMLRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class DefaultIDocXMLProcessor
implements IDocXMLProcessor {
    private IDocFactory iDocFactory = null;

    public DefaultIDocXMLProcessor(IDocFactory iDocFactory) {
        this.iDocFactory = iDocFactory;
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString) throws IDocParseException {
        return this.parse(repository, xmlString, null, 0, null, null);
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString, IDocXMLFormat format) throws IDocParseException {
        return this.parse(repository, xmlString, format, 0, null, null);
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString, int options) throws IDocParseException {
        return this.parse(repository, xmlString, null, options, null, null);
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString, int options, String systemRelease, String applicationRelease) throws IDocParseException {
        return this.parse(repository, xmlString, null, options, systemRelease, applicationRelease);
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString, IDocXMLFormat format, int options) throws IDocParseException {
        return this.parse(repository, xmlString, format, options, null, null);
    }

    public IDocDocumentList parse(IDocRepository repository, String xmlString, IDocXMLFormat format, int options, String systemRelease, String applicationRelease) throws IDocParseException {
        IDocDocumentList iDocList = null;
        StringReader stringReader = new StringReader(xmlString);
        try {
            iDocList = this.parse(repository, stringReader, format, options, systemRelease, applicationRelease);
        }
        catch (IOException exc) {
            // empty catch block
        }
        return iDocList;
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream) throws IOException, IDocParseException {
        return this.parse(repository, xmlStream, null, 0);
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream, IDocXMLFormat format) throws IOException, IDocParseException {
        return this.parse(repository, xmlStream, format, 0);
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream, int options) throws IOException, IDocParseException {
        return this.parse(repository, xmlStream, null, options);
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream, int options, String systemRelease, String applicationRelease) throws IOException, IDocParseException {
        return this.parse(repository, xmlStream, null, options, systemRelease, applicationRelease);
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream, IDocXMLFormat format, int options) throws IOException, IDocParseException {
        DefaultIDocXMLParser parser = new DefaultIDocXMLParser(this.iDocFactory, repository, xmlStream, format, options, null, null);
        return parser.parse();
    }

    public IDocDocumentList parse(IDocRepository repository, InputStream xmlStream, IDocXMLFormat format, int options, String systemRelease, String applicationRelease) throws IOException, IDocParseException {
        DefaultIDocXMLParser parser = new DefaultIDocXMLParser(this.iDocFactory, repository, xmlStream, format, options, systemRelease, applicationRelease);
        return parser.parse();
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader) throws IOException, IDocParseException {
        return this.parse(repository, xmlReader, null, 0);
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader, IDocXMLFormat format) throws IOException, IDocParseException {
        return this.parse(repository, xmlReader, format, 0);
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader, int options) throws IOException, IDocParseException {
        return this.parse(repository, xmlReader, null, options);
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader, int options, String systemRelease, String applicationRelease) throws IOException, IDocParseException {
        return this.parse(repository, xmlReader, null, options, systemRelease, applicationRelease);
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader, IDocXMLFormat format, int options) throws IOException, IDocParseException {
        DefaultIDocXMLParser parser = new DefaultIDocXMLParser(this.iDocFactory, repository, xmlReader, format, options, null, null);
        return parser.parse();
    }

    public IDocDocumentList parse(IDocRepository repository, Reader xmlReader, IDocXMLFormat format, int options, String systemRelease, String applicationRelease) throws IOException, IDocParseException {
        DefaultIDocXMLParser parser = new DefaultIDocXMLParser(this.iDocFactory, repository, xmlReader, format, options, systemRelease, applicationRelease);
        return parser.parse();
    }

    public String render(IDocDocument iDoc) {
        return this.render(iDoc, IDocXMLFormat.SAP_RELEASE_610, null, 0);
    }

    public String render(IDocDocument iDoc, IDocXMLFormat format) {
        return this.render(iDoc, format, null, 0);
    }

    public String render(IDocDocument iDoc, String encoding) {
        return this.render(iDoc, IDocXMLFormat.SAP_RELEASE_610, encoding, 0);
    }

    public String render(IDocDocument iDoc, int options) {
        return this.render(iDoc, IDocXMLFormat.SAP_RELEASE_610, null, options);
    }

    public String render(IDocDocument iDoc, IDocXMLFormat format, String encoding) {
        return this.render(iDoc, format, encoding, 0);
    }

    public String render(IDocDocument iDoc, IDocXMLFormat format, int options) {
        return this.render(iDoc, format, null, options);
    }

    public String render(IDocDocument iDoc, String encoding, int options) {
        return this.render(iDoc, IDocXMLFormat.SAP_RELEASE_610, encoding, options);
    }

    public String render(IDocDocument iDoc, IDocXMLFormat format, String encoding, int options) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.render(iDoc, (Writer)stringWriter, format, encoding, options);
        }
        catch (IOException exc) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void render(IDocDocument iDoc, Writer xmlWriter) throws IOException {
        this.render(iDoc, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, null, 0);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, IDocXMLFormat format) throws IOException {
        this.render(iDoc, xmlWriter, format, null, 0);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, String encoding) throws IOException {
        this.render(iDoc, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, encoding, 0);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, int options) throws IOException {
        this.render(iDoc, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, null, options);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, IDocXMLFormat format, String encoding) throws IOException {
        this.render(iDoc, xmlWriter, format, encoding, 0);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, IDocXMLFormat format, int options) throws IOException {
        this.render(iDoc, xmlWriter, format, null, options);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, String encoding, int options) throws IOException {
        this.render(iDoc, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, encoding, options);
    }

    public void render(IDocDocument iDoc, Writer xmlWriter, IDocXMLFormat format, String encoding, int options) throws IOException {
        DefaultIDocXMLRenderer renderer = new DefaultIDocXMLRenderer(iDoc, xmlWriter, format, encoding, options);
        renderer.render();
    }

    public String render(IDocDocumentList iDocList) {
        return this.render(iDocList, IDocXMLFormat.SAP_RELEASE_610, null, 0);
    }

    public String render(IDocDocumentList iDocList, IDocXMLFormat format) {
        return this.render(iDocList, format, null, 0);
    }

    public String render(IDocDocumentList iDocList, String encoding) {
        return this.render(iDocList, IDocXMLFormat.SAP_RELEASE_610, encoding, 0);
    }

    public String render(IDocDocumentList iDocList, int options) {
        return this.render(iDocList, IDocXMLFormat.SAP_RELEASE_610, null, options);
    }

    public String render(IDocDocumentList iDocList, IDocXMLFormat format, String encoding) {
        return this.render(iDocList, format, encoding, 0);
    }

    public String render(IDocDocumentList iDocList, IDocXMLFormat format, int options) {
        return this.render(iDocList, format, null, options);
    }

    public String render(IDocDocumentList iDocList, String encoding, int options) {
        return this.render(iDocList, IDocXMLFormat.SAP_RELEASE_610, encoding, options);
    }

    public String render(IDocDocumentList iDocList, IDocXMLFormat format, String encoding, int options) {
        StringWriter xmlWriter = new StringWriter();
        try {
            this.render(iDocList, (Writer)xmlWriter, format, encoding, options);
        }
        catch (IOException exc) {
            // empty catch block
        }
        return xmlWriter.toString();
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter) throws IOException {
        this.render(iDocList, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, null, 0);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, IDocXMLFormat format) throws IOException {
        this.render(iDocList, xmlWriter, format, null, 0);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, String encoding) throws IOException {
        this.render(iDocList, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, encoding, 0);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, int options) throws IOException {
        this.render(iDocList, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, null, options);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, IDocXMLFormat format, String encoding) throws IOException {
        this.render(iDocList, xmlWriter, format, encoding, 0);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, IDocXMLFormat format, int options) throws IOException {
        this.render(iDocList, xmlWriter, format, null, options);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, String encoding, int options) throws IOException {
        this.render(iDocList, xmlWriter, IDocXMLFormat.SAP_RELEASE_610, encoding, options);
    }

    public void render(IDocDocumentList iDocList, Writer xmlWriter, IDocXMLFormat format, String encoding, int options) throws IOException {
        DefaultIDocXMLRenderer renderer = new DefaultIDocXMLRenderer(iDocList, xmlWriter, format, encoding, options);
        renderer.render();
    }
}

