/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.xml;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentIterator;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentIterator;
import com.sap.conn.idoc.IDocXMLFormat;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.xml.XMLChar;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Locale;

public class DefaultIDocXMLRenderer {
    private static final char AMP = '&';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char NUM = '#';
    private static final char SEM = ';';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private static final char BOM = '\ufeff';
    private static final char[] AMPNUM = new char[]{'&', '#'};
    private static final char[] LTSL = new char[]{'<', '/'};
    private static final char[] SLGT = new char[]{'/', '>'};
    private static final char[] ESC_AMP = new char[]{'&', '#', '3', '8', ';'};
    private static final char[] ESC_LT = new char[]{'&', '#', '6', '0', ';'};
    private static final char[] ESC_SL = new char[]{'_', '-'};
    private static final char[] ESC_HEX = new char[]{'_', '-', '-'};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String IDOC_TAG = "IDOC";
    private static final String IDOC_ATTRIBS = " BEGIN=\"1\"";
    private static final String CONTROL_TAG = "EDI_DC40";
    private static final String CONTROL_ATTRIBS = " SEGMENT=\"1\"";
    private static final String SEGMENT_ATTRIBS = " SEGMENT=\"1\"";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String ESC_CDATA_END = "]]]]><![CDATA[>";
    private static final String XMLDECL_START = "<?xml";
    private static final String XMLDECL_END = "?>";
    private static final String XMLVERSIONINFO_10 = " version=\"1.0\"";
    private static final String XMLVERSIONINFO_11 = " version=\"1.1\"";
    private static final String XMLENCODING_START = " encoding=\"";
    private static final String XMLENCODING_END = "\"";
    private final int RENDER_WITH_TABS = 4;
    private static final String[] CONTROL_FIELDS = new String[]{"TABNAM", "MANDT", "DOCNUM", "DOCREL", "STATUS", "DIRECT", "OUTMOD", "EXPRSS", "TEST", "IDOCTYP", "CIMTYP", "MESTYP", "MESCOD", "MESFCT", "STD", "STDVRS", "STDMES", "SNDPOR", "SNDPRT", "SNDPFC", "SNDPRN", "SNDSAD", "SNDLAD", "RCVPOR", "RCVPRT", "RCVPFC", "RCVPRN", "RCVSAD", "RCVLAD", "CREDAT", "CRETIM", "REFINT", "REFGRP", "REFMES", "ARCKEY", "SERIAL"};
    private IDocDocument iDoc = null;
    private IDocDocumentList iDocList = null;
    private Writer writer = null;
    private IDocXMLFormat format = IDocXMLFormat.SAP_RELEASE_610;
    private String encoding = null;
    private int options = 0;
    private StringBuilder buffer = new StringBuilder();
    private LinkedList<String> openTags = new LinkedList();

    protected DefaultIDocXMLRenderer(IDocDocument iDoc, Writer xmlWriter, IDocXMLFormat format, String encoding, int options) {
        this.iDoc = iDoc;
        this.writer = xmlWriter;
        this.format = format;
        this.encoding = encoding;
        this.options = this.evaluateOptions(options);
    }

    protected DefaultIDocXMLRenderer(IDocDocumentList iDocList, Writer xmlWriter, IDocXMLFormat format, String encoding, int options) {
        this.iDocList = iDocList;
        this.writer = xmlWriter;
        this.format = format;
        this.encoding = encoding;
        this.options = this.evaluateOptions(options);
    }

    protected int evaluateOptions(int options) {
        if (DefaultIDocRuntime.xmlRenderOptions_useAlways != 0) {
            options |= DefaultIDocRuntime.xmlRenderOptions_useAlways;
        }
        options = (options & 0x20) != 0 ? (options &= 0xFFFFFFEF) : ((options & 0x10) != 0 ? (options &= 0xFFFFFFDF) : (DefaultIDocRuntime.xmlRenderOption_defaultXMLVersion != 0 ? (options |= DefaultIDocRuntime.xmlRenderOption_defaultXMLVersion) : ((options & 0x100) != 0 ? (options |= 0x10) : (options |= 0x20))));
        if ((options & 0x80000) != 0) {
            options &= 0xFFFBFFFF;
        }
        return options;
    }

    public void render() throws IOException {
        if ((this.options & 0x100) == 0) {
            this.xmlDeclaration();
        }
        if (this.iDoc != null) {
            String iDocTypeExtension = this.iDoc.getIDocTypeExtension();
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                this.startTag(iDocTypeExtension, true, "");
            } else {
                this.startTag(this.iDoc.getIDocType(), true, "");
            }
            this.renderIDoc(this.iDoc);
            this.endTag(true);
        } else if (this.iDocList != null && this.iDocList.getNumDocuments() > 0) {
            String iDocTypeExtension = this.iDocList.getIDocTypeExtension();
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                this.startTag(iDocTypeExtension, true, "");
            } else {
                this.startTag(this.iDocList.getIDocType(), true, "");
            }
            IDocDocumentIterator iterator = this.iDocList.iterator();
            while (iterator.hasNext()) {
                this.renderIDoc(iterator.next());
            }
            this.endTag(true);
        }
    }

    protected void endTag(boolean considerTabs) throws IOException {
        if (considerTabs && (this.options & 4) != 0) {
            int s = this.openTags.size() - 1;
            for (int i = 0; i < s; ++i) {
                this.writer.write(9);
            }
        }
        this.writer.write(LTSL);
        this.writer.write(this.openTags.removeLast());
        this.writer.write(62);
        if ((this.options & 1) != 0) {
            this.writer.write(13);
        }
        if ((this.options & 2) != 0) {
            this.writer.write(10);
        }
    }

    protected void emptyTag(String tagname, boolean escape) throws IOException {
        if ((this.options & 4) != 0) {
            int s = this.openTags.size();
            for (int i = 0; i < s; ++i) {
                this.writer.write(9);
            }
        }
        this.writer.write(60);
        this.writer.write(escape ? this.escapeTag(tagname) : tagname);
        this.writer.write(SLGT);
        if ((this.options & 1) != 0) {
            this.writer.write(13);
        }
        if ((this.options & 2) != 0) {
            this.writer.write(10);
        }
    }

    protected String errorMessageEscapeTag(String tagname, char c) {
        StringBuilder errMsg = new StringBuilder(145 + tagname.length()).append("Segment type or field name \"").append(tagname).append("\" cannot be escaped to an IDocXML format version ").append(this.format == IDocXMLFormat.SAP_RELEASE_46 ? "4.6" : "6.10").append(" compliant element tag because of the contained character U+");
        for (int i = 12; i >= 0; i -= 4) {
            errMsg.append(HEX[c >>> i & 0xF]);
        }
        return errMsg.toString();
    }

    protected String errorMessageInvalidChar(String value, char c) {
        StringBuilder errMsg = new StringBuilder(117 + value.length()).append("Field content \"").append(value).append("\" cannot be rendered to a well-formed XML version ").append((this.options & 0x10) != 0 ? "1.0" : "1.1").append(" string because of the contained character U+");
        for (int i = 12; i >= 0; i -= 4) {
            errMsg.append(HEX[c >>> i & 0xF]);
        }
        return errMsg.toString();
    }

    protected String escapeTag(String tagname) {
        this.buffer.setLength(0);
        int len = tagname.length();
        switch (this.format) {
            case SAP_RELEASE_46: {
                for (int i = 0; i < len; ++i) {
                    char c = tagname.charAt(i);
                    if (XMLChar.isBasicLatinLetter(c)) {
                        this.buffer.append(c);
                        continue;
                    }
                    if (i > 0 && (XMLChar.isBasicLatinDigit(c) || c == '_')) {
                        this.buffer.append(c);
                        continue;
                    }
                    if (c == '/') {
                        this.buffer.append(i == 0 ? (char)'_' : '-');
                        continue;
                    }
                    if ((this.options & 0x20000) != 0) {
                        this.buffer.append(c);
                        continue;
                    }
                    throw new IDocRuntimeException(this.errorMessageEscapeTag(tagname, c));
                }
                break;
            }
            default: {
                for (int i = 0; i < len; ++i) {
                    char c = tagname.charAt(i);
                    if (XMLChar.isBasicLatinLetter(c) || c == '_') {
                        this.buffer.append(c);
                        continue;
                    }
                    if (i > 0 && (XMLChar.isBasicLatinDigit(c) || c == '.')) {
                        this.buffer.append(c);
                        continue;
                    }
                    if (c == '/') {
                        this.buffer.append(ESC_SL);
                        continue;
                    }
                    if ((this.options & 0x20000) != 0 || i == 0 && XMLChar.isBasicLatinDigit(c) || c == ' ' || c == '!' || c >= '#' && c <= '&' || c >= '(' && c <= '*' || c == '.' || c == '<' || c >= '>' && c <= '@' || c >= '{' && c <= '~') {
                        if (i > 0 && XMLChar.isNameChar(c) || i == 0 && XMLChar.isNameStartChar(c)) {
                            this.buffer.append(c);
                            continue;
                        }
                        if (c <= '\u00ff') {
                            this.buffer.append(ESC_HEX);
                            this.buffer.append(HEX[c >> 4 & 0xF]);
                            this.buffer.append(HEX[c & 0xF]);
                            continue;
                        }
                        this.buffer.append(c);
                        continue;
                    }
                    throw new IDocRuntimeException(this.errorMessageEscapeTag(tagname, c));
                }
            }
        }
        return this.buffer.toString();
    }

    protected void renderIDoc(IDocDocument idoc) throws IOException {
        this.startTag(IDOC_TAG, false, IDOC_ATTRIBS);
        this.renderIDocControlRecord(idoc);
        IDocSegmentIterator iterator = idoc.getRootSegment().getChildrenIterator();
        while (iterator.hasNext()) {
            this.renderIDocSegment(iterator.next());
        }
        this.endTag(true);
    }

    protected void renderIDocControlRecord(IDocDocument idoc) throws IOException {
        this.startTag(CONTROL_TAG, false, " SEGMENT=\"1\"");
        try {
            boolean renderEmptyTags = (this.options & 0x10000) != 0;
            String value = null;
            int numFields = CONTROL_FIELDS.length;
            for (int i = 0; i < numFields; ++i) {
                value = idoc.getString(CONTROL_FIELDS[i]);
                if (value.length() == 0) {
                    if (!renderEmptyTags) continue;
                    this.emptyTag(CONTROL_FIELDS[i], false);
                    continue;
                }
                this.startTag(CONTROL_FIELDS[i], false);
                this.value(value);
                this.endTag(false);
            }
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
        this.endTag(true);
    }

    protected void renderIDocSegment(IDocSegment segment) throws IOException {
        this.startTagBegin(segment.getType(), true, " SEGMENT=\"1\"");
        boolean startTagUnfinished = true;
        boolean renderEmptyTags = (this.options & 0x10000) != 0;
        String value = null;
        int numFields = segment.getNumFields();
        for (int i = 0; i < numFields; ++i) {
            value = segment.getString(i);
            if (value.length() == 0) {
                if (!renderEmptyTags) continue;
                if (startTagUnfinished) {
                    this.startTagFinish(false);
                    startTagUnfinished = false;
                }
                this.emptyTag(segment.getName(i), true);
                continue;
            }
            if (startTagUnfinished) {
                this.startTagFinish(false);
                startTagUnfinished = false;
            }
            this.startTag(segment.getName(i), true);
            this.value(value);
            this.endTag(false);
        }
        if (segment.isParent()) {
            if (startTagUnfinished) {
                this.startTagFinish(false);
                startTagUnfinished = false;
            }
            IDocSegmentIterator iterator = segment.getChildrenIterator();
            while (iterator.hasNext()) {
                this.renderIDocSegment(iterator.next());
            }
        }
        if (startTagUnfinished) {
            this.startTagFinish(true);
        } else {
            this.endTag(true);
        }
    }

    protected void startTag(String tagname, boolean escape) throws IOException {
        String tag;
        String string = tag = escape ? this.escapeTag(tagname) : tagname;
        if ((this.options & 4) != 0) {
            int s = this.openTags.size();
            for (int i = 0; i < s; ++i) {
                this.writer.write(9);
            }
        }
        this.writer.write(60);
        this.writer.write(tag);
        this.writer.write(62);
        this.openTags.add(tag);
    }

    protected void startTag(String tagname, boolean escape, String attributes) throws IOException {
        this.startTagBegin(tagname, escape, attributes);
        this.startTagFinish(false);
    }

    protected void startTagBegin(String tagname, boolean escape, String attributes) throws IOException {
        String tag;
        String string = tag = escape ? this.escapeTag(tagname) : tagname;
        if ((this.options & 4) != 0) {
            int s = this.openTags.size();
            for (int i = 0; i < s; ++i) {
                this.writer.write(9);
            }
        }
        this.writer.write(60);
        this.writer.write(tag);
        this.writer.write(attributes);
        this.openTags.add(tag);
    }

    protected void startTagFinish(boolean asEmptyTag) throws IOException {
        if (asEmptyTag) {
            this.writer.write(SLGT);
            this.openTags.removeLast();
        } else {
            this.writer.write(62);
        }
        if ((this.options & 1) != 0) {
            this.writer.write(13);
        }
        if ((this.options & 2) != 0) {
            this.writer.write(10);
        }
    }

    protected void value(String value) throws IOException {
        int len = value.length();
        switch (this.format) {
            case SAP_RELEASE_46: {
                char c;
                int i;
                boolean escape = false;
                boolean substitute = false;
                for (i = 0; i < len; ++i) {
                    c = value.charAt(i);
                    if (c == '<' || c == '&') {
                        escape = true;
                        continue;
                    }
                    if (XMLChar.isRestrictedChar(c)) {
                        if ((this.options & 0x20) != 0 || (this.options & 0x40000) != 0 || (this.options & 0x10) != 0 && XMLChar.isValidV10(c)) {
                            escape = true;
                            continue;
                        }
                        if ((this.options & 0x80000) != 0) {
                            substitute = true;
                            continue;
                        }
                        throw new IDocRuntimeException(this.errorMessageInvalidChar(value, c));
                    }
                    if (!XMLChar.isInvalidIgnoreSurrogates(c)) continue;
                    if ((this.options & 0x40000) != 0) {
                        escape = true;
                        continue;
                    }
                    if ((this.options & 0x80000) != 0) {
                        substitute = true;
                        continue;
                    }
                    throw new IDocRuntimeException(this.errorMessageInvalidChar(value, c));
                }
                if (escape) {
                    int offset = 0;
                    int index = 0;
                    int length = 0;
                    this.writer.write(CDATA_START);
                    while (offset < len) {
                        int i2;
                        index = value.indexOf(CDATA_END, offset);
                        if (index < 0) {
                            length = len - offset;
                            if (!substitute) {
                                this.writer.write(value, offset, length);
                            } else {
                                for (i2 = offset; i2 < length; ++i2) {
                                    c = value.charAt(i2);
                                    if (XMLChar.isRestrictedChar(c)) {
                                        if ((this.options & 0x20) != 0 || (this.options & 0x10) != 0 && XMLChar.isValidV10(c)) {
                                            this.writer.write(c);
                                            continue;
                                        }
                                        this.writer.write(35);
                                        continue;
                                    }
                                    if (XMLChar.isInvalidIgnoreSurrogates(c)) {
                                        this.writer.write(35);
                                        continue;
                                    }
                                    this.writer.write(c);
                                }
                            }
                            offset = len;
                            continue;
                        }
                        length = index - offset;
                        if (!substitute) {
                            this.writer.write(value, offset, length);
                        } else {
                            for (i2 = offset; i2 < length; ++i2) {
                                c = value.charAt(i2);
                                if (XMLChar.isRestrictedChar(c)) {
                                    if ((this.options & 0x20) != 0 || (this.options & 0x10) != 0 && XMLChar.isValidV10(c)) {
                                        this.writer.write(c);
                                        continue;
                                    }
                                    this.writer.write(35);
                                    continue;
                                }
                                if (XMLChar.isInvalidIgnoreSurrogates(c)) {
                                    this.writer.write(35);
                                    continue;
                                }
                                this.writer.write(c);
                            }
                        }
                        this.writer.write(ESC_CDATA_END);
                        offset += length + CDATA_END.length();
                    }
                    this.writer.write(CDATA_END);
                    break;
                }
                if (substitute) {
                    for (i = 0; i < len; ++i) {
                        c = value.charAt(i);
                        if (XMLChar.isRestrictedChar(c) || XMLChar.isInvalidIgnoreSurrogates(c)) {
                            this.writer.write(35);
                            continue;
                        }
                        this.writer.write(c);
                    }
                    break;
                }
                this.writer.write(value);
                break;
            }
            default: {
                for (int i = 0; i < len; ++i) {
                    char c = value.charAt(i);
                    if (c == '<') {
                        this.writer.write(ESC_LT);
                        continue;
                    }
                    if (c == '&') {
                        this.writer.write(ESC_AMP);
                        continue;
                    }
                    if (XMLChar.isRestrictedChar(c)) {
                        if ((this.options & 0x20) != 0 || (this.options & 0x40000) != 0 || (this.options & 0x10) != 0 && XMLChar.isValidV10(c)) {
                            this.writer.write(AMPNUM);
                            this.writer.write(Integer.toString(c));
                            this.writer.write(59);
                            continue;
                        }
                        if ((this.options & 0x80000) != 0) {
                            this.writer.write(35);
                            continue;
                        }
                        throw new IDocRuntimeException(this.errorMessageInvalidChar(value, c));
                    }
                    if (XMLChar.isInvalidIgnoreSurrogates(c)) {
                        if ((this.options & 0x40000) != 0) {
                            this.writer.write(AMPNUM);
                            this.writer.write(Integer.toString(c));
                            this.writer.write(59);
                            continue;
                        }
                        if ((this.options & 0x80000) != 0) {
                            this.writer.write(35);
                            continue;
                        }
                        throw new IDocRuntimeException(this.errorMessageInvalidChar(value, c));
                    }
                    this.writer.write(c);
                }
            }
        }
    }

    protected void xmlDeclaration() throws IOException {
        String xmlEncoding = this.encoding;
        if ((xmlEncoding == null || xmlEncoding.length() == 0) && this.writer instanceof OutputStreamWriter) {
            xmlEncoding = ((OutputStreamWriter)this.writer).getEncoding();
        }
        if (xmlEncoding != null && xmlEncoding.length() > 0) {
            try {
                xmlEncoding = Charset.forName(xmlEncoding).name();
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        if (xmlEncoding != null && xmlEncoding.length() > 0) {
            String enc = xmlEncoding.toUpperCase(Locale.ENGLISH);
            if (enc.indexOf("UTF-16") >= 0 || enc.indexOf("UTF-32") >= 0 || enc.indexOf("UCS-2") >= 0 || enc.indexOf("UCS-4") >= 0) {
                this.writer.write(65279);
            }
            this.writer.write(XMLDECL_START);
            if ((this.options & 0x10) != 0) {
                this.writer.write(XMLVERSIONINFO_10);
            } else {
                this.writer.write(XMLVERSIONINFO_11);
            }
            if (!((this.options & 0x200) == 0 && (enc.equals("UTF-8") || enc.equals("UTF-16") || enc.equals("UTF-16BE") || enc.equals("UTF-16LE") || enc.equals("US-ASCII")))) {
                this.writer.write(XMLENCODING_START);
                this.writer.write(xmlEncoding);
                this.writer.write(XMLENCODING_END);
            }
            this.writer.write(XMLDECL_END);
        } else {
            this.writer.write(XMLDECL_START);
            if ((this.options & 0x10) != 0) {
                this.writer.write(XMLVERSIONINFO_10);
            } else {
                this.writer.write(XMLVERSIONINFO_11);
            }
            this.writer.write(XMLDECL_END);
        }
        if ((this.options & 1) != 0) {
            this.writer.write(13);
        }
        if ((this.options & 2) != 0) {
            this.writer.write(10);
        }
    }
}

