/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.xml;

public class XMLChar {
    public static final int IS_VALID = 1;
    public static final int IS_HIGH_SURROGATE = 2;
    public static final int IS_LOW_SURROGATE = 4;
    public static final int IS_SURROGATE = 6;
    public static final int IS_VALID_OR_SURROGATE = 7;
    public static final int IS_WHITE_SPACE = 8;
    public static final int IS_BASIC_LATIN_CAPITAL_LETTER = 16;
    public static final int IS_BASIC_LATIN_SMALL_LETTER = 32;
    public static final int IS_BASIC_LATIN_LETTER = 48;
    public static final int IS_ENCNAME_START = 48;
    public static final int IS_BASIC_LATIN_DIGIT = 64;
    public static final int IS_DECDIGIT = 64;
    public static final int IS_ENCNAME_SPECIAL = 128;
    public static final int IS_ENCNAME = 240;
    public static final int IS_BASE = 256;
    public static final int IS_IDEOGRAPHIC = 512;
    public static final int IS_LETTER = 768;
    public static final int IS_DIGIT = 1024;
    public static final int IS_COMBINING = 2048;
    public static final int IS_EXTENDER = 4096;
    public static final int IS_NAME_START_SPECIAL = 8192;
    public static final int IS_NAME_ADDITIONAL_SPECIAL = 16384;
    public static final int IS_NAME_SPECIAL = 24576;
    public static final int IS_NAME_START = 8240;
    public static final int IS_NAME = 24688;
    public static final int IS_NMTOKEN = 24688;
    public static final int IS_PUBID_SPECIAL = 32768;
    public static final int IS_PUBID = 32880;
    public static final int IS_MARKUP = 65536;
    public static final int IS_RESTRICTED = 131072;
    public static final int IS_VALID_V10 = 0x100000;
    public static final int IS_VALID_V10_OR_SURROGATE = 0x100006;
    public static final int IS_HEXDIGIT_CAPITAL_LETTER = 0x1000000;
    public static final int IS_HEXDIGIT_SMALL_LETTER = 0x2000000;
    public static final int IS_HEXDIGIT_LETTER = 0x3000000;
    public static final int IS_HEXDIGIT = 0x3000040;
    public static final int[] CHAR = new int[65536];

    public static char highSurrogate(int c) {
        return (char)((c - 65536 >>> 10) + 55296);
    }

    public static final boolean isBaseChar(char c) {
        return (CHAR[c] & 0x100) != 0;
    }

    public static final boolean isBaseChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x100) != 0;
    }

    public static final boolean isBasicLatinCapitalLetter(char c) {
        return (CHAR[c] & 0x10) != 0;
    }

    public static final boolean isBasicLatinCapitalLetter(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x10) != 0;
    }

    public static final boolean isBasicLatinDigit(char c) {
        return (CHAR[c] & 0x40) != 0;
    }

    public static final boolean isBasicLatinDigit(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x40) != 0;
    }

    public static final boolean isBasicLatinLetter(char c) {
        return (CHAR[c] & 0x30) != 0;
    }

    public static final boolean isBasicLatinLetter(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x30) != 0;
    }

    public static final boolean isBasicLatinSmallLetter(char c) {
        return (CHAR[c] & 0x20) != 0;
    }

    public static final boolean isBasicLatinSmallLetter(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x20) != 0;
    }

    public static final boolean isCombiningChar(char c) {
        return (CHAR[c] & 0x800) != 0;
    }

    public static final boolean isCombiningChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x800) != 0;
    }

    public static final boolean isDecDigit(char c) {
        return (CHAR[c] & 0x40) != 0;
    }

    public static final boolean isDecDigit(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x40) != 0;
    }

    public static final boolean isDigit(char c) {
        return (CHAR[c] & 0x400) != 0;
    }

    public static final boolean isDigit(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x400) != 0;
    }

    public static final boolean isEncNameChar(char c) {
        return (CHAR[c] & 0xF0) != 0;
    }

    public static final boolean isEncNameChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0xF0) != 0;
    }

    public static final boolean isEncNameStartChar(char c) {
        return (CHAR[c] & 0x30) != 0;
    }

    public static final boolean isEncNameStartChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x30) != 0;
    }

    public static final boolean isExtender(char c) {
        return (CHAR[c] & 0x1000) != 0;
    }

    public static final boolean isExtender(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x1000) != 0;
    }

    public static final boolean isHexDigit(char c) {
        return (CHAR[c] & 0x3000040) != 0;
    }

    public static final boolean isHexDigit(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x3000040) != 0;
    }

    public static final boolean isHighSurrogate(char c) {
        return (CHAR[c] & 2) != 0;
    }

    public static final boolean isIdeographic(char c) {
        return (CHAR[c] & 0x200) != 0;
    }

    public static final boolean isIdeographic(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x200) != 0;
    }

    public static final boolean isInBasicMultilingualPlane(int c) {
        return 0 <= c && c <= 65535;
    }

    public static final boolean isInSupplementaryPlane(int c) {
        return 65536 <= c && c <= 0x10FFFF;
    }

    public static final boolean isInvalid(char c) {
        return (CHAR[c] & 1) == 0;
    }

    public static final boolean isInvalid(int c) {
        return c < 0 || c <= 65535 && (CHAR[c] & 1) == 0 || c >= 0x110000;
    }

    public static final boolean isInvalidIgnoreSurrogates(char c) {
        return (CHAR[c] & 7) == 0;
    }

    public static final boolean isInvalidV10(char c) {
        return (CHAR[c] & 0x100000) == 0;
    }

    public static final boolean isInvalidV10(int c) {
        return c < 0 || c <= 65535 && (CHAR[c] & 0x100000) == 0 || c >= 0x110000;
    }

    public static final boolean isInvalidV10IgnoreSurrogates(char c) {
        return (CHAR[c] & 0x100006) == 0;
    }

    public static final boolean isLetter(char c) {
        return (CHAR[c] & 0x300) != 0;
    }

    public static final boolean isLetter(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x300) != 0;
    }

    public static final boolean isLowSurrogate(char c) {
        return (CHAR[c] & 4) != 0;
    }

    public static final boolean isMarkupChar(char c) {
        return (CHAR[c] & 0x10000) != 0;
    }

    public static final boolean isMarkupChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x10000) != 0;
    }

    public static final boolean isNameChar(char c) {
        return (CHAR[c] & 0x6070) != 0;
    }

    public static final boolean isNameChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x6070) != 0 || 65536 <= c && c <= 983039;
    }

    public static final boolean isNameStartChar(char c) {
        return (CHAR[c] & 0x2030) != 0;
    }

    public static final boolean isNameStartChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x2030) != 0 || 65536 <= c && c <= 983039;
    }

    public static final boolean isNCNameChar(char c) {
        return c != ':' && XMLChar.isNameChar(c);
    }

    public static final boolean isNCNameChar(int c) {
        return c != 58 && XMLChar.isNameChar(c);
    }

    public static final boolean isNCNameStartChar(char c) {
        return c != ':' && XMLChar.isNameStartChar(c);
    }

    public static final boolean isNCNameStartChar(int c) {
        return c != 58 && XMLChar.isNameStartChar(c);
    }

    public static final boolean isPubidChar(char c) {
        return (CHAR[c] & 0x8070) != 0;
    }

    public static final boolean isPubidChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x8070) != 0;
    }

    public static final boolean isRestrictedChar(char c) {
        return (CHAR[c] & 0x20000) != 0;
    }

    public static final boolean isRestrictedChar(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x20000) != 0;
    }

    public static final boolean isSurrogate(char c) {
        return (CHAR[c] & 6) != 0;
    }

    public static final boolean isValid(char c) {
        return (CHAR[c] & 1) != 0;
    }

    public static final boolean isValid(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 1) != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static final boolean isValidIgnoreSurrogates(char c) {
        return (CHAR[c] & 7) != 0;
    }

    public static final boolean isValidV10(char c) {
        return (CHAR[c] & 0x100000) != 0;
    }

    public static final boolean isValidV10(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 0x100000) != 0 || 65536 <= c && c <= 0x10FFFF;
    }

    public static final boolean isValidV10IgnoreSurrogates(char c) {
        return (CHAR[c] & 0x100006) != 0;
    }

    public static final boolean isWhiteSpace(char c) {
        return (CHAR[c] & 8) != 0;
    }

    public static final boolean isWhiteSpace(int c) {
        return 0 <= c && c <= 65535 && (CHAR[c] & 8) != 0;
    }

    public static final char lowSurrogate(int c) {
        return (char)((c - 65536 & 0x3FF) + 56320);
    }

    public static final int supplementaryChar(char high, char low) {
        return high - 55296 << 10 + (low - 56320) + 65536;
    }

    static {
        int[] restrictedCharRanges = new int[]{1, 8, 11, 12, 14, 31, 127, 132, 134, 159};
        char[] whiteSpaceChars = new char[]{'\t', '\n', '\r', ' '};
        char[] encNameSpecialChars = new char[]{'-', '.', '_'};
        int[] baseCharRanges = new int[]{65, 90, 97, 122, 192, 214, 216, 246, 248, 255, 256, 305, 308, 318, 321, 328, 330, 382, 384, 451, 461, 496, 500, 501, 506, 535, 592, 680, 699, 705, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 982, 986, 986, 988, 988, 990, 990, 992, 992, 994, 1011, 1025, 1036, 1038, 1103, 1105, 1116, 1118, 1153, 1168, 1220, 1223, 1224, 1227, 1228, 1232, 1259, 1262, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1414, 1488, 1514, 1520, 1522, 1569, 1594, 1601, 1610, 1649, 1719, 1722, 1726, 1728, 1742, 1744, 1747, 1749, 1749, 1765, 1766, 2309, 2361, 2365, 2365, 2392, 2401, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2784, 2784, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3294, 3294, 3296, 3297, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3424, 3425, 3585, 3630, 3632, 3632, 3634, 3635, 3648, 3653, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3758, 3760, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3904, 3911, 3913, 3945, 4256, 4293, 4304, 4342, 4352, 4352, 4354, 4355, 4357, 4359, 4361, 4361, 4363, 4364, 4366, 4370, 4412, 4412, 4414, 4414, 4416, 4416, 4428, 4428, 4430, 4430, 4432, 4432, 4436, 4437, 4441, 4441, 4447, 4449, 4451, 4451, 4453, 4453, 4455, 4455, 4457, 4457, 4461, 4462, 4466, 4467, 4469, 4469, 4510, 4510, 4520, 4520, 4523, 4523, 4526, 4527, 4535, 4536, 4538, 4538, 4540, 4546, 4587, 4587, 4592, 4592, 4601, 4601, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8486, 8486, 8490, 8491, 8494, 8494, 8576, 8578, 12353, 12436, 12449, 12538, 12549, 12588, 44032, 55203};
        int[] ideographicRanges = new int[]{12295, 12295, 12321, 12329, 19968, 40869};
        int[] digitRanges = new int[]{48, 57, 1632, 1641, 1776, 1785, 2406, 2415, 2534, 2543, 2662, 2671, 2790, 2799, 2918, 2927, 3047, 3055, 3174, 3183, 3302, 3311, 3430, 3439, 3664, 3673, 3792, 3801, 3872, 3881};
        int[] combiningCharRanges = new int[]{768, 837, 864, 865, 1155, 1158, 1425, 1441, 1443, 1465, 1467, 1469, 1471, 1471, 1473, 1474, 1476, 1476, 1611, 1618, 1648, 1648, 1750, 1756, 1757, 1759, 1760, 1764, 1767, 1768, 1770, 1773, 2305, 2307, 2364, 2364, 2366, 2380, 2381, 2381, 2385, 2388, 2402, 2403, 2433, 2435, 2492, 2492, 2494, 2494, 2495, 2495, 2496, 2500, 2503, 2504, 2507, 2509, 2519, 2519, 2530, 2531, 2562, 2562, 2620, 2620, 2622, 2622, 2623, 2623, 2624, 2626, 2631, 2632, 2635, 2637, 2672, 2673, 2689, 2691, 2748, 2748, 2750, 2757, 2759, 2761, 2763, 2765, 2817, 2819, 2876, 2876, 2878, 2883, 2887, 2888, 2891, 2893, 2902, 2903, 2946, 2947, 3006, 3010, 3014, 3016, 3018, 3021, 3031, 3031, 3073, 3075, 3134, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3202, 3203, 3262, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3330, 3331, 3390, 3395, 3398, 3400, 3402, 3405, 3415, 3415, 3633, 3633, 3636, 3642, 3655, 3662, 3761, 3761, 3764, 3769, 3771, 3772, 3784, 3789, 3864, 3865, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3902, 3903, 3903, 3953, 3972, 3974, 3979, 3984, 3989, 3991, 3991, 3993, 4013, 4017, 4023, 4025, 4025, 8400, 8412, 8417, 8417, 12330, 12335, 12441, 12441, 12442, 12442};
        int[] extenderRanges = new int[]{183, 183, 720, 721, 903, 903, 1600, 1600, 3654, 3654, 3782, 3782, 12293, 12293, 12337, 12341, 12445, 12446, 12540, 12542};
        int[] nameStartSpecialCharRanges = new int[]{58, 58, 95, 95, 192, 214, 216, 246, 248, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 64975, 65008, 65533};
        int[] nameAdditionalSpecialCharRanges = new int[]{45, 46, 183, 183, 768, 879, 8255, 8256};
        char[] pubidSpecialChars = new char[]{'\n', '\r', ' ', '!', '#', '$', '%', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '=', '?', '@', '_'};
        char[] markupChars = new char[]{'%', '&', '<'};
        int i = 0;
        int j = 0;
        for (i = 1; i < 32; ++i) {
            XMLChar.CHAR[i] = 1;
        }
        while (i < 55296) {
            XMLChar.CHAR[i] = 0x100001;
            ++i;
        }
        while (i < 56320) {
            XMLChar.CHAR[i] = 2;
            ++i;
        }
        while (i < 57344) {
            XMLChar.CHAR[i] = 4;
            ++i;
        }
        while (i < 65534) {
            XMLChar.CHAR[i] = 0x100001;
            ++i;
        }
        for (i = 0; i < restrictedCharRanges.length; i += 2) {
            j = restrictedCharRanges[i];
            while (j <= restrictedCharRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x20000;
            }
        }
        for (i = 0; i < whiteSpaceChars.length; ++i) {
            char c = whiteSpaceChars[i];
            CHAR[c] = CHAR[c] | 0x100008;
        }
        i = 48;
        while (i <= 57) {
            int n = i++;
            CHAR[n] = CHAR[n] | 0x40;
        }
        i = 65;
        while (i <= 70) {
            int n = i++;
            CHAR[n] = CHAR[n] | 0x1000010;
        }
        while (i <= 90) {
            int n = i++;
            CHAR[n] = CHAR[n] | 0x10;
        }
        i = 97;
        while (i <= 102) {
            int n = i++;
            CHAR[n] = CHAR[n] | 0x2000020;
        }
        while (i <= 122) {
            int n = i++;
            CHAR[n] = CHAR[n] | 0x20;
        }
        for (i = 0; i < encNameSpecialChars.length; ++i) {
            char c = encNameSpecialChars[i];
            CHAR[c] = CHAR[c] | 0x80;
        }
        for (i = 0; i < baseCharRanges.length; i += 2) {
            j = baseCharRanges[i];
            while (j <= baseCharRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x100;
            }
        }
        for (i = 0; i < ideographicRanges.length; i += 2) {
            j = ideographicRanges[i];
            while (j <= ideographicRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x200;
            }
        }
        for (i = 0; i < digitRanges.length; i += 2) {
            j = digitRanges[i];
            while (j <= digitRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x400;
            }
        }
        for (i = 0; i < combiningCharRanges.length; i += 2) {
            j = combiningCharRanges[i];
            while (j <= combiningCharRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x800;
            }
        }
        for (i = 0; i < extenderRanges.length; i += 2) {
            j = extenderRanges[i];
            while (j <= extenderRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x1000;
            }
        }
        for (i = 0; i < nameStartSpecialCharRanges.length; i += 2) {
            j = nameStartSpecialCharRanges[i];
            while (j <= nameStartSpecialCharRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x2000;
            }
        }
        for (i = 0; i < nameAdditionalSpecialCharRanges.length; i += 2) {
            j = nameAdditionalSpecialCharRanges[i];
            while (j <= nameAdditionalSpecialCharRanges[i + 1]) {
                int n = j++;
                CHAR[n] = CHAR[n] | 0x4000;
            }
        }
        for (i = 0; i < pubidSpecialChars.length; ++i) {
            char c = pubidSpecialChars[i];
            CHAR[c] = CHAR[c] | 0x8000;
        }
        for (i = 0; i < markupChars.length; ++i) {
            char c = markupChars[i];
            CHAR[c] = CHAR[c] | 0x10000;
        }
    }
}

