/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.JCoRuntime;
import java.io.Serializable;
import java.util.Arrays;

public class AbapFunctionTemplate
implements Serializable,
JCoFunctionTemplate {
    static final long serialVersionUID = 3000120080918L;
    private String name;
    String comment = "";
    private JCoListMetaData importParameters;
    private JCoListMetaData exportParameters;
    private JCoListMetaData changingParameters;
    private JCoListMetaData tableParameters;
    private AbapExceptionModel[] exceptionList;
    private boolean supportingASXML;

    public AbapFunctionTemplate(String name, JCoListMetaData input, JCoListMetaData output, JCoListMetaData changing, JCoListMetaData tables, AbapExceptionModel[] exceptions, boolean asXMLSupport) {
        if (name == null) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Function name is null and not allowed.");
        }
        this.name = name;
        this.importParameters = input;
        this.exportParameters = output;
        this.changingParameters = changing;
        this.tableParameters = tables;
        this.exceptionList = exceptions;
        this.supportingASXML = asXMLSupport;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JCoListMetaData getImportParameterList() {
        return this.importParameters;
    }

    @Override
    public JCoListMetaData getExportParameterList() {
        return this.exportParameters;
    }

    @Override
    public JCoListMetaData getChangingParameterList() {
        return this.changingParameters;
    }

    @Override
    public JCoListMetaData getTableParameterList() {
        return this.tableParameters;
    }

    @Override
    public AbapException[] getExceptionList() {
        if (this.exceptionList == null) {
            return null;
        }
        AbapException[] exceptions = new AbapException[this.exceptionList.length];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = this.exceptionList[i].createAbapException();
        }
        return exceptions;
    }

    @Override
    public AbapException getException(String key) {
        if (this.exceptionList == null) {
            return null;
        }
        for (int i = 0; i < this.exceptionList.length; ++i) {
            if (!this.exceptionList[i].getKey().equalsIgnoreCase(key)) continue;
            return this.exceptionList[i].createAbapException();
        }
        return null;
    }

    @Override
    public JCoListMetaData getFunctionInterface() {
        JCoRecordMetaData recordMetaData;
        int i;
        int parameterCount = (this.importParameters == null ? 0 : this.importParameters.getFieldCount()) + (this.exportParameters == null ? 0 : this.exportParameters.getFieldCount()) + (this.changingParameters == null ? 0 : this.changingParameters.getFieldCount()) + (this.tableParameters == null ? 0 : this.tableParameters.getFieldCount()) + (this.exceptionList == null ? 0 : this.exceptionList.length);
        DefaultListMetaData functionInterface = new DefaultListMetaData(this.name, parameterCount);
        if (this.importParameters != null) {
            for (i = 0; i < this.importParameters.getFieldCount(); ++i) {
                recordMetaData = this.importParameters.getRecordMetaData(i);
                functionInterface.add(this.importParameters.getName(i), this.importParameters.getType(i), this.importParameters.getByteLength(i), this.importParameters.getUnicodeByteLength(i), this.importParameters.getDecimals(i), this.importParameters.getDefault(i), this.importParameters.getDescription(i), this.importParameters.isOptional(i) ? 3 : 2, recordMetaData == null ? null : this.importParameters.getRecordTypeName(i), this.importParameters.getRecordFieldName(i), this.importParameters.getExtendedFieldMetaData(i));
            }
        }
        if (this.exportParameters != null) {
            for (i = 0; i < this.exportParameters.getFieldCount(); ++i) {
                recordMetaData = this.exportParameters.getRecordMetaData(i);
                functionInterface.add(this.exportParameters.getName(i), this.exportParameters.getType(i), this.exportParameters.getByteLength(i), this.exportParameters.getUnicodeByteLength(i), this.exportParameters.getDecimals(i), this.exportParameters.getDefault(i), this.exportParameters.getDescription(i), this.exportParameters.isOptional(i) ? 5 : 4, recordMetaData == null ? null : this.exportParameters.getRecordTypeName(i), this.exportParameters.getRecordFieldName(i), this.exportParameters.getExtendedFieldMetaData(i));
            }
        }
        if (this.changingParameters != null) {
            for (i = 0; i < this.changingParameters.getFieldCount(); ++i) {
                recordMetaData = this.changingParameters.getRecordMetaData(i);
                functionInterface.add(this.changingParameters.getName(i), this.changingParameters.getType(i), this.changingParameters.getByteLength(i), this.changingParameters.getUnicodeByteLength(i), this.changingParameters.getDecimals(i), this.changingParameters.getDefault(i), this.changingParameters.getDescription(i), this.changingParameters.isOptional(i) ? 9 : 8, recordMetaData == null ? null : this.changingParameters.getRecordTypeName(i), this.changingParameters.getRecordFieldName(i), this.changingParameters.getExtendedFieldMetaData(i));
            }
        }
        if (this.tableParameters != null) {
            for (i = 0; i < this.tableParameters.getFieldCount(); ++i) {
                functionInterface.add(this.tableParameters.getName(i), this.tableParameters.getType(i), this.tableParameters.getByteLength(i), this.tableParameters.getUnicodeByteLength(i), this.tableParameters.getDecimals(i), this.tableParameters.getDefault(i), this.tableParameters.getDescription(i), this.tableParameters.isOptional(i) ? 1 : 0, this.tableParameters.getRecordMetaData(i), null, this.tableParameters.getExtendedFieldMetaData(i));
            }
        }
        if (this.exceptionList != null) {
            for (i = 0; i < this.exceptionList.length; ++i) {
                functionInterface.add(this.exceptionList[i].getKey(), 98, 0, 0, 0, null, this.exceptionList[i].getMessage(), 0, null, null, null);
            }
        }
        functionInterface.lock();
        return functionInterface;
    }

    @Override
    public AbapFunction getFunction() {
        return new AbapFunction(this);
    }

    @Override
    public DefaultRequest getRequest() {
        return new DefaultRequest(new AbapFunction(this));
    }

    @Override
    public boolean supportsASXML() {
        return this.supportingASXML;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Function: ").append(this.name).append(JCoRuntime.CRLF);
        if (this.supportingASXML) {
            sb.append("supports (binary) ASXML semantics").append(JCoRuntime.CRLF);
        }
        sb.append("Input:").append(JCoRuntime.CRLF).append(this.importParameters);
        if (this.importParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append("Changing:").append(JCoRuntime.CRLF).append(this.changingParameters);
        if (this.changingParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append("Output:").append(JCoRuntime.CRLF).append(this.exportParameters);
        if (this.exportParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append("Tables:").append(JCoRuntime.CRLF).append(this.tableParameters);
        if (this.tableParameters == null) {
            sb.append(JCoRuntime.CRLF);
        }
        sb.append("Exceptions:");
        if (this.exceptionList != null) {
            for (int i = 0; i < this.exceptionList.length; ++i) {
                sb.append(this.exceptionList[i].getKey()).append("  (").append(this.exceptionList[i].getMessage()).append(")").append(JCoRuntime.CRLF);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AbapFunctionTemplate) {
            AbapFunctionTemplate t = (AbapFunctionTemplate)o;
            if (!this.name.equals(t.name)) {
                return false;
            }
            if (this.supportingASXML != t.supportingASXML) {
                return false;
            }
            if (this.importParameters == null && t.importParameters != null || this.importParameters != null && t.importParameters == null) {
                return false;
            }
            if (this.importParameters != null && !this.importParameters.equals(t.importParameters)) {
                return false;
            }
            if (this.changingParameters == null && t.changingParameters != null || this.changingParameters != null && t.changingParameters == null) {
                return false;
            }
            if (this.changingParameters != null && !this.changingParameters.equals(t.changingParameters)) {
                return false;
            }
            if (this.exportParameters == null && t.exportParameters != null || this.exportParameters != null && t.exportParameters == null) {
                return false;
            }
            if (this.exportParameters != null && !this.exportParameters.equals(t.exportParameters)) {
                return false;
            }
            if (this.tableParameters == null && t.tableParameters != null || this.tableParameters != null && t.tableParameters == null) {
                return false;
            }
            if (this.tableParameters != null && !this.tableParameters.equals(t.tableParameters)) {
                return false;
            }
            if (this.exceptionList == null && t.exceptionList != null || this.exceptionList != null && t.exceptionList == null) {
                return false;
            }
            return this.exceptionList == null || Arrays.equals(this.exceptionList, t.exceptionList);
        }
        return false;
    }

    public int hashCode() {
        int i = this.name.hashCode();
        i ^= this.importParameters != null ? this.importParameters.hashCode() : 1;
        i ^= this.exportParameters != null ? this.exportParameters.hashCode() : 2;
        i ^= this.changingParameters != null ? this.changingParameters.hashCode() : 3;
        i ^= this.tableParameters != null ? this.tableParameters.hashCode() : 4;
        return i ^= this.exceptionList != null ? this.exceptionList.hashCode() : 5;
    }
}

