/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.json.Field;
import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import com.sap.conn.jco.rt.json.JSonContainerReader;
import com.sap.conn.jco.rt.json.JSonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class JSonFunctionTemplateReader
extends JSonContainerReader {
    private boolean basXmlEnabled;
    private String name;
    private List<AbapExceptionModel> exceptions;
    private JCoListMetaData input;
    private JCoListMetaData changing;
    private JCoListMetaData output;
    private JCoListMetaData tables;

    JSonFunctionTemplateReader(JSonParser parser) {
        super(parser);
    }

    @Override
    JSonFunctionTemplateReader read(String name) throws IOException {
        this.name = name;
        this.input = JCo.createListMetaData("INPUT");
        this.changing = JCo.createListMetaData("CHANGING");
        this.output = JCo.createListMetaData("OUTPUT");
        this.tables = JCo.createListMetaData("TABLES");
        this.exceptions = new ArrayList<AbapExceptionModel>();
        this.readFunctionTemplateAttributes();
        AbapExceptionModel[] excs = this.prepareExceptions(this.exceptions);
        this.input = this.prepareList(this.input);
        this.changing = this.prepareList(this.changing);
        this.output = this.prepareList(this.output);
        this.tables = this.prepareList(this.tables);
        AbapFunctionTemplate ft = new AbapFunctionTemplate(name, this.input, this.output, this.changing, this.tables, excs, this.basXmlEnabled);
        this.repo.addFunctionTemplateToCache(ft);
        return this;
    }

    private AbapExceptionModel[] prepareExceptions(List<AbapExceptionModel> excList) {
        AbapExceptionModel[] excs = null;
        if (excList.size() > 0) {
            excs = new AbapExceptionModel[this.exceptions.size()];
            excs = this.exceptions.toArray(excs);
        }
        return excs;
    }

    private JCoListMetaData prepareList(JCoListMetaData list) {
        if (list.getFieldCount() > 0) {
            list.lock();
        } else {
            list = null;
        }
        return list;
    }

    void readFunctionTemplateAttributes() throws IOException {
        while (this.parser.nextNonBlankChar() == 44) {
            String attribute = this.parser.nextString();
            this.parser.assertChar(':');
            if ("basXmlEnabled".equals(attribute)) {
                this.basXmlEnabled = this.parser.nextBool();
                continue;
            }
            if ("parameters".equals(attribute)) {
                this.readFields();
                continue;
            }
            if ("exceptions".equals(attribute)) {
                this.readExceptions();
                continue;
            }
            throw new JCoRepositorySerializationException("unknown FUNCTION attribute \"" + attribute + "\"", this.parser);
        }
        this.parser.undo();
    }

    @Override
    void setField(Field f) throws IOException {
        JCoListMetaData lmd = null;
        int flags = 0;
        switch (Direction.valueOf(f.direction)) {
            case IMPORT: {
                lmd = this.input;
                flags = 2;
                break;
            }
            case CHANGING: {
                lmd = this.changing;
                flags = 8;
                break;
            }
            case EXPORT: {
                lmd = this.output;
                flags = 4;
                break;
            }
            case TABLES: {
                lmd = this.tables;
            }
        }
        if (f.optional) {
            flags |= 1;
        }
        lmd.add(f.name, AbstractMetaData.getJCOType(f.type), f.nucLength, f.ucLength, f.decimals, f.defaultValue, f.descr, flags, f.ddicName, f.recordFieldName, null);
    }

    void readExceptions() throws IOException {
        this.parser.assertChar('[');
        if (this.parser.nextNonBlankChar() == 123) {
            while (true) {
                String key = null;
                String doc = null;
                do {
                    String attribute;
                    if ("key".equals(attribute = this.parser.nextString())) {
                        this.parser.assertChar(':');
                        key = this.parser.nextString();
                        continue;
                    }
                    if ("doc".equals(attribute)) {
                        this.parser.assertChar(':');
                        doc = this.parser.nextString();
                        continue;
                    }
                    throw new JCoRepositorySerializationException("unknown exception attribute \"" + attribute + "\"", this.parser);
                } while (this.parser.nextNonBlankChar() == 44);
                this.parser.undo();
                this.parser.assertChar('}');
                if (key == null) {
                    throw new JCoRepositorySerializationException("missing attribute \"key\" when defining exception for function " + this.name);
                }
                this.exceptions.add(new AbapExceptionModel(key, doc));
                if (this.parser.nextNonBlankChar() != 44) break;
                this.parser.assertChar('{');
            }
            this.parser.undo();
        } else {
            this.parser.undo();
        }
        this.parser.assertChar(']');
    }

    public static enum Direction {
        IMPORT,
        EXPORT,
        CHANGING,
        TABLES;

    }
}

