/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.rt.json.RepWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class JSonWriter
extends Writer {
    private static final String LF = System.getProperty("line.separator");
    Writer writer;

    public JSonWriter(Writer w) {
        this.writer = w;
    }

    public JSonWriter write(JCoRepository r) throws IOException {
        new RepWriter(r).write(this);
        return this;
    }

    void writeNVPair(String name, String value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(58);
        this.writeQuoted(JSonWriter.escapeString(value));
    }

    void writeQuoted(String str) throws IOException {
        this.writer.write(34);
        this.writer.write(str);
        this.writer.write(34);
    }

    static String escapeString(String s) {
        StringBuffer r = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                r.append("\\\\");
                continue;
            }
            if (c <= '\"') {
                if (c == '\"') {
                    r.append("\\\"");
                    continue;
                }
                if (c == '\u0007') {
                    r.append("\\a");
                    continue;
                }
                if (c == '\b') {
                    r.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    r.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    r.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    r.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    r.append("\\t");
                    continue;
                }
                if (c == '\u000b') {
                    r.append("\\v");
                    continue;
                }
                if (c == '\u0000') {
                    r.append("\\0");
                    continue;
                }
                r.append(c);
                continue;
            }
            r.append(c);
        }
        return r.toString();
    }

    void writeNVPair(String name, char value) throws IOException {
        this.writeNVPair(name, String.valueOf(value));
    }

    void writeSubsequentPair(String key, boolean value) throws IOException {
        this.writer.write(44);
        this.writeNVPair(key, value);
    }

    void writeNVPair(String name, boolean value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(":");
        this.writer.write(String.valueOf(value));
    }

    void writeNVPair(String name, Object value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(58);
        this.writer.write(value.toString());
    }

    void writeSubsequentPair(String key, Object value) throws IOException {
        String valueS;
        if (value != null && (valueS = value.toString()).length() > 0) {
            this.writer.write(44);
            this.writeNVPair(key, value);
        }
    }

    void writeSubsequentPair(String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.writer.write(44);
            this.writeNVPair(key, value);
        }
    }

    void writeSubsequentPair(String name, char value) throws IOException {
        this.writer.write(44);
        this.writeNVPair(name, value);
    }

    void writeStrings(String key, List<String> stringList) throws IOException {
        this.writeQuoted(key);
        this.writer.write(58);
        this.writer.write(91);
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                first = false;
            } else {
                this.writer.write(44);
            }
            this.writer.write(34);
            this.writer.write(JSonWriter.escapeString(str));
            this.writer.write(34);
        }
        this.writer.write(93);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void writeLine() throws IOException {
        this.writer.write(LF);
    }
}

