/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.JCoTraceWriter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class SapLoggingTrace
extends Trace
implements JCoTraceWriter {
    private static Location location = null;
    private static Category category = null;
    private static JCoTraceWriter singleton = null;
    private int currentSeverity = 701;

    protected SapLoggingTrace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<SapLoggingTrace> clazz = SapLoggingTrace.class;
        synchronized (SapLoggingTrace.class) {
            if (singleton == null) {
                singleton = new SapLoggingTrace();
                Trace.addTraceWriter(singleton);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getTraceLevel() {
        int logLevel = 0;
        int severity = location.getEffectiveSeverity();
        if (severity == 701) {
            logLevel = 0;
        } else if (severity == 500) {
            logLevel |= 2;
        } else if (severity == 400) {
            logLevel |= 6;
        } else if (severity == 300) {
            logLevel |= 0xE;
        } else if (severity == 200) {
            logLevel |= 0x4E;
        } else if (severity == 100) {
            logLevel |= 0x1FE;
        } else if (severity == 0) {
            logLevel |= 0x1FE;
        }
        if (this.currentSeverity != severity) {
            this.currentSeverity = severity;
            Trace.writeInfo(this);
        }
        return logLevel;
    }

    @Override
    public void trace(int level, String message) {
        try {
            if (level == 0) {
                location.logT(701, message);
            } else if ((level & 2) != 0) {
                category.errorT(location, message);
            } else if ((level & 4) != 0) {
                location.logT(400, message);
            } else if ((level & 8) != 0) {
                location.logT(300, message);
            } else if ((level & 0x40) != 0) {
                location.logT(200, message);
            } else {
                location.logT(100, message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        location = Location.getLocation("com.sap.conn.jco");
        String[] categories = new String[]{"System", "Server", "Connector", "Rfc"};
        try {
            category = Category.getRoot();
            for (int i = 0; i < categories.length; ++i) {
                category = Category.getCategory(category, categories[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

