/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.jco.rt.JCoRuntime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Compress {
    public static final int CS_LZH = 2;
    public static final int CS_HEAD_SIZE = 8;
    public static final int CS_END_INBUFFER = 3;
    public static final int CS_END_OUTBUFFER = 2;
    public static final int CS_END_OF_STREAM = 1;
    public static final int CS_OK = 0;
    public static final int CS_NORMAL_COMPRESS = 0;
    public static final int CS_INIT_COMPRESS = 1;
    public static final int CS_INIT_DECOMPRESS = 1;
    public static final int COMPRESS_SIZE_OUT = 2048;
    public static final int COMPRESS_SIZE_IN = 4096;
    public static final int DECOMPRESS_SIZE_IN = 2048;
    public static final int DECOMPRESS_SIZE_OUT = 4096;

    public static synchronized native int CsRGetHandle();

    public static native int CsRInitCompress(int var0, byte[] var1, int var2, int var3);

    public static synchronized native void CsRCloseHandle(int var0);

    public static native int CsRCompress(int var0, int var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int[] var9);

    public static native int CsRInitDecompress(int var0, byte[] var1);

    public static native int CsRDecompress(int var0, byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int[] var7);

    static {
        JCoRuntime.registerNatives(Compress.class);
    }

    public static class CsInputStream
    extends InputStream {
        private InputStream inStream;
        private byte[] outBuffer = new byte[4128];
        private byte[] inBuffer = new byte[2080];
        private int inLen;
        private int outOffset;
        private int outLen;
        private int[] csRes = new int[3];
        private int csHandle;
        private int csRc = 0;

        public CsInputStream(InputStream iS) throws IOException {
            this.inStream = iS;
            int bytesRead = this.inStream.read(this.inBuffer, 0, 8);
            if (bytesRead < 8) {
                throw new IOException("unable to read cs header");
            }
            this.csHandle = Compress.CsRGetHandle();
            this.csRc = Compress.CsRInitDecompress(this.csHandle, this.inBuffer);
            if (this.csRc != 0) {
                Compress.CsRCloseHandle(this.csHandle);
                throw new IOException("CS error: " + this.csRc);
            }
            this.outLen = 0;
            this.outOffset = 0;
            this.csRc = 3;
        }

        @Override
        public int read(byte[] b, int off, int expected) throws IOException {
            int resultBytes = 0;
            while (expected > 0) {
                if (this.outLen > 0) {
                    if (this.outLen >= expected) {
                        System.arraycopy(this.outBuffer, this.outOffset, b, off, expected);
                        this.outLen -= expected;
                        this.outOffset += expected;
                        resultBytes += expected;
                        break;
                    }
                    System.arraycopy(this.outBuffer, this.outOffset, b, off, this.outLen);
                    off += this.outLen;
                    expected -= this.outLen;
                    resultBytes += this.outLen;
                    this.outOffset = 0;
                    this.outLen = 0;
                }
                if (this.csRc == 3) {
                    this.inLen = this.inStream.read(this.inBuffer, this.inLen, this.inBuffer.length - this.inLen);
                    if (this.inLen == -1) {
                        throw new IOException("Unexpected end of the input stream");
                    }
                } else if (this.csRc == 1) break;
                Compress.CsRDecompress(this.csHandle, this.inBuffer, 0, this.inLen, this.outBuffer, this.outBuffer.length, 0, this.csRes);
                int bytesRead = this.csRes[0];
                this.outLen = this.csRes[1];
                this.csRc = this.csRes[2];
                this.outOffset = 0;
                if (this.csRc < 0) {
                    Compress.CsRCloseHandle(this.csHandle);
                    throw new IOException("CS returns 1000" + -this.csRc);
                }
                int lastByte = this.inLen;
                this.inLen -= bytesRead;
                if (this.inLen <= 0) continue;
                int i = bytesRead;
                int j = 0;
                while (i < lastByte) {
                    this.inBuffer[j] = this.inBuffer[i];
                    ++i;
                    ++j;
                }
            }
            if (resultBytes == 0 && this.csRc == 1) {
                return -1;
            }
            return resultBytes;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int result = this.read(b, 0, b.length);
            if (result < 0) {
                return result;
            }
            return b[0];
        }

        @Override
        public void close() throws IOException {
            this.inStream.close();
        }
    }

    public static class CsOutputStream
    extends OutputStream {
        private OutputStream outStream;
        private byte[] outBuffer = new byte[2080];
        private byte[] inBuffer = new byte[4128];
        private int inPos = 0;
        private int totalLength;
        private int[] csRes = new int[3];
        private int csHandle;

        public CsOutputStream(OutputStream out, int totalLength) throws IOException {
            this.outStream = out;
            this.totalLength = totalLength;
            this.csHandle = Compress.CsRGetHandle();
            int csRc = Compress.CsRInitCompress(this.csHandle, this.outBuffer, totalLength, 2);
            if (csRc != 0) {
                Compress.CsRCloseHandle(this.csHandle);
                throw new IOException("CS error: " + csRc);
            }
            this.outStream.write(this.outBuffer, 0, 8);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.outStream.close();
        }

        @Override
        public void flush() throws IOException {
            int csRc = 0;
            while (this.inPos > 0 || csRc == 2) {
                Compress.CsRCompress(this.csHandle, this.totalLength, this.inBuffer, 0, this.inPos, this.outBuffer, 0, this.outBuffer.length, 0, this.csRes);
                int bytesRead = this.csRes[0];
                int bytesCompressed = this.csRes[1];
                csRc = this.csRes[2];
                if (csRc < 0) {
                    Compress.CsRCloseHandle(this.csHandle);
                    throw new IOException("CsCompress returned " + (1000 + -this.csRes[2]));
                }
                if (bytesCompressed > 0) {
                    this.outStream.write(this.outBuffer, 0, bytesCompressed);
                }
                this.inPos -= bytesRead;
                if (this.inPos <= 0) continue;
                System.arraycopy(this.inBuffer, bytesRead, this.inBuffer, 0, this.inPos);
            }
            if (csRc == 1 && this.inPos > 0) {
                throw new IOException("CS_END_OF_STREAM although len is still > 0 [" + this.inPos + "]");
            }
            this.outStream.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int workLen = this.inBuffer.length - this.inPos;
                if (workLen > len) {
                    workLen = len;
                }
                System.arraycopy(b, off, this.inBuffer, this.inPos, workLen);
                off += workLen;
                this.inPos += workLen;
                if ((len -= workLen) <= 0) continue;
                int inPosBefore = this.inPos;
                this.flush();
                if (inPosBefore == this.inPos) {
                    this.flush();
                }
                if (inPosBefore != this.inPos) continue;
                throw new IOException("flush without result - stop to avoid infinite loop");
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }
    }
}

