/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Camel Api Route test generated by camel-component-util-maven-plugin
 * Generated on: Wed Jul 09 19:57:11 PDT 2014
 */
package org.apache.camel.component.linkedin;

import java.util.HashMap;
import java.util.Map;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.linkedin.api.model.Person;
import org.apache.camel.component.linkedin.internal.LinkedInApiCollection;
import org.apache.camel.component.linkedin.internal.PeopleResourceApiMethod;

import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Test class for {@link org.apache.camel.component.linkedin.api.PeopleResource} APIs.
 */
public class PeopleResourceIntegrationTest extends AbstractLinkedInTestSupport {

    private static final Logger LOG = LoggerFactory.getLogger(PeopleResourceIntegrationTest.class);
    private static final String PATH_PREFIX = "people";

    // TODO provide parameter values for addActivity
    @Ignore
    @Test
    public void testAddActivity() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.Activity message body for single parameter "activity"
        requestBody("direct://ADDACTIVITY", null);
    }

    // TODO provide parameter values for addGroupMembership
    @Ignore
    @Test
    public void testAddGroupMembership() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.GroupMembership message body for single parameter "groupmembership"
        requestBody("direct://ADDGROUPMEMBERSHIP", null);
    }

    // TODO provide parameter values for addInvite
    @Ignore
    @Test
    public void testAddInvite() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.MailboxItem message body for single parameter "mailboxitem"
        requestBody("direct://ADDINVITE", null);
    }

    // TODO provide parameter values for addJobBookmark
    @Ignore
    @Test
    public void testAddJobBookmark() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.JobBookmark message body for single parameter "jobbookmark"
        requestBody("direct://ADDJOBBOOKMARK", null);
    }

    // TODO provide parameter values for addUpdateComment
    @Ignore
    @Test
    public void testAddUpdateComment() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.update_key", null);
        // parameter type is org.apache.camel.component.linkedin.api.model.UpdateComment
        headers.put("CamelLinkedIn.updatecomment", null);

        requestBodyAndHeaders("direct://ADDUPDATECOMMENT", null, headers);
    }

    // TODO provide parameter values for followCompany
    @Ignore
    @Test
    public void testFollowCompany() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.Company message body for single parameter "company"
        requestBody("direct://FOLLOWCOMPANY", null);
    }

    @Test
    public void testGetConnections() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // use defaults
/*
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);
*/

        final org.apache.camel.component.linkedin.api.model.Connections result = requestBodyAndHeaders("direct://GETCONNECTIONS", null, headers);

        assertNotNull("getConnections result", result);
        LOG.debug("getConnections: " + result);
    }

    // TODO provide parameter values for getConnectionsById
    @Ignore
    @Test
    public void testGetConnectionsById() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.person_id", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final org.apache.camel.component.linkedin.api.model.Connections result = requestBodyAndHeaders("direct://GETCONNECTIONSBYID", null, headers);

        assertNotNull("getConnectionsById result", result);
        LOG.debug("getConnectionsById: " + result);
    }

    // TODO provide parameter values for getConnectionsByUrl
    @Ignore
    @Test
    public void testGetConnectionsByUrl() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.public_profile_url", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final org.apache.camel.component.linkedin.api.model.Connections result = requestBodyAndHeaders("direct://GETCONNECTIONSBYURL", null, headers);

        assertNotNull("getConnectionsByUrl result", result);
        LOG.debug("getConnectionsByUrl: " + result);
    }

    @Test
    public void testGetFollowedCompanies() throws Exception {
        // using String message body for single parameter "fields"
        final org.apache.camel.component.linkedin.api.model.Companies result = requestBody("direct://GETFOLLOWEDCOMPANIES", "");

        assertNotNull("getFollowedCompanies result", result);
        LOG.debug("getFollowedCompanies: " + result);
    }

    // TODO provide parameter values for getGroupMembershipSettings
    @Ignore
    @Test
    public void testGetGroupMembershipSettings() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelLinkedIn.group_id", 0L);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);

        final org.apache.camel.component.linkedin.api.model.GroupMembership result = requestBodyAndHeaders("direct://GETGROUPMEMBERSHIPSETTINGS", null, headers);

        assertNotNull("getGroupMembershipSettings result", result);
        LOG.debug("getGroupMembershipSettings: " + result);
    }

    @Test
    public void testGetGroupMemberships() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // use defaults
/*
        // parameter type is org.apache.camel.component.linkedin.api.model.MembershipState
        headers.put("CamelLinkedIn.membership_state", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
*/

        final org.apache.camel.component.linkedin.api.model.GroupMemberships result = requestBodyAndHeaders("direct://GETGROUPMEMBERSHIPS", null, headers);

        assertNotNull("getGroupMemberships result", result);
        LOG.debug("getGroupMemberships: " + result);
    }

    @Test
    public void testGetJobBookmarks() throws Exception {
        final org.apache.camel.component.linkedin.api.model.JobBookmarks result = requestBody("direct://GETJOBBOOKMARKS", null);

        assertNotNull("getJobBookmarks result", result);
        LOG.debug("getJobBookmarks: " + result);
    }

    @Test
    public void testGetNetworkStats() throws Exception {
        final org.apache.camel.component.linkedin.api.model.NetworkStats result = requestBody("direct://GETNETWORKSTATS", null);

        assertNotNull("getNetworkStats result", result);
        LOG.debug("getNetworkStats: " + result);
    }

    @Test
    public void testGetNetworkUpdates() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // use defaults
/*
        // parameter type is String
        headers.put("CamelLinkedIn.scope", null);
        // parameter type is org.apache.camel.component.linkedin.api.Type
        headers.put("CamelLinkedIn.type", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.after", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.before", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.show_hidden_members", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);
*/

        final org.apache.camel.component.linkedin.api.model.Updates result = requestBodyAndHeaders("direct://GETNETWORKUPDATES", null, headers);

        assertNotNull("getNetworkUpdates result", result);
        LOG.debug("getNetworkUpdates: " + result);
    }

    // TODO provide parameter values for getNetworkUpdatesById
    @Ignore
    @Test
    public void testGetNetworkUpdatesById() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.scope", null);
        // parameter type is org.apache.camel.component.linkedin.api.Type
        headers.put("CamelLinkedIn.type", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.after", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.before", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.show_hidden_members", null);
        // parameter type is String
        headers.put("CamelLinkedIn.person_id", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final org.apache.camel.component.linkedin.api.model.Updates result = requestBodyAndHeaders("direct://GETNETWORKUPDATESBYID", null, headers);

        assertNotNull("getNetworkUpdatesById result", result);
        LOG.debug("getNetworkUpdatesById: " + result);
    }

    @Test
    public void testGetPerson() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.fields", "");
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", true);

        final Person result = requestBodyAndHeaders("direct://GETPERSON", null, headers);

        assertNotNull("getPerson result", result);
        LOG.debug("getPerson: " + result);
    }

    // TODO provide parameter values for getPersonById
    @Ignore
    @Test
    public void testGetPersonById() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.person_id", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final Person result = requestBodyAndHeaders("direct://GETPERSONBYID", null, headers);

        assertNotNull("getPersonById result", result);
        LOG.debug("getPersonById: " + result);
    }

    // TODO provide parameter values for getPersonByUrl
    @Ignore
    @Test
    public void testGetPersonByUrl() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.public_profile_url", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final Person result = requestBodyAndHeaders("direct://GETPERSONBYURL", null, headers);

        assertNotNull("getPersonByUrl result", result);
        LOG.debug("getPersonByUrl: " + result);
    }

    // TODO provide parameter values for getPosts
    @Ignore
    @Test
    public void testGetPosts() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelLinkedIn.group_id", 0L);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is org.apache.camel.component.linkedin.api.Order
        headers.put("CamelLinkedIn.order", null);
        // parameter type is org.apache.camel.component.linkedin.api.Role
        headers.put("CamelLinkedIn.role", null);
        // parameter type is org.apache.camel.component.linkedin.api.Category
        headers.put("CamelLinkedIn.category", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.modified_since", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);

        final org.apache.camel.component.linkedin.api.model.Posts result = requestBodyAndHeaders("direct://GETPOSTS", null, headers);

        assertNotNull("getPosts result", result);
        LOG.debug("getPosts: " + result);
    }

    @Test
    public void testGetSuggestedCompanies() throws Exception {
        // using String message body for single parameter "fields"
        final org.apache.camel.component.linkedin.api.model.Companies result = requestBody("direct://GETSUGGESTEDCOMPANIES", "");

        assertNotNull("getSuggestedCompanies result", result);
        LOG.debug("getSuggestedCompanies: " + result);
    }

    // TODO provide parameter values for getSuggestedGroupPosts
    @Ignore
    @Test
    public void testGetSuggestedGroupPosts() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelLinkedIn.group_id", 0L);
        // parameter type is Long
        headers.put("CamelLinkedIn.start", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.count", null);
        // parameter type is org.apache.camel.component.linkedin.api.Order
        headers.put("CamelLinkedIn.order", null);
        // parameter type is org.apache.camel.component.linkedin.api.Role
        headers.put("CamelLinkedIn.role", null);
        // parameter type is org.apache.camel.component.linkedin.api.Category
        headers.put("CamelLinkedIn.category", null);
        // parameter type is Long
        headers.put("CamelLinkedIn.modified_since", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);

        final org.apache.camel.component.linkedin.api.model.Posts result = requestBodyAndHeaders("direct://GETSUGGESTEDGROUPPOSTS", null, headers);

        assertNotNull("getSuggestedGroupPosts result", result);
        LOG.debug("getSuggestedGroupPosts: " + result);
    }

    @Test
    public void testGetSuggestedGroups() throws Exception {
        // using String message body for single parameter "fields"
        final org.apache.camel.component.linkedin.api.model.Groups result = requestBody("direct://GETSUGGESTEDGROUPS", "");

        assertNotNull("getSuggestedGroups result", result);
        LOG.debug("getSuggestedGroups: " + result);
    }

    @Test
    public void testGetSuggestedJobs() throws Exception {
        // using String message body for single parameter "fields"
        final org.apache.camel.component.linkedin.api.model.JobSuggestions result = requestBody("direct://GETSUGGESTEDJOBS", "");

        assertNotNull("getSuggestedJobs result", result);
        LOG.debug("getSuggestedJobs: " + result);
    }

    // TODO provide parameter values for getUpdateComments
    @Ignore
    @Test
    public void testGetUpdateComments() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.update_key", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final org.apache.camel.component.linkedin.api.model.UpdateComments result = requestBodyAndHeaders("direct://GETUPDATECOMMENTS", null, headers);

        assertNotNull("getUpdateComments result", result);
        LOG.debug("getUpdateComments: " + result);
    }

    // TODO provide parameter values for getUpdateLikes
    @Ignore
    @Test
    public void testGetUpdateLikes() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.update_key", null);
        // parameter type is String
        headers.put("CamelLinkedIn.fields", null);
        // parameter type is Boolean
        headers.put("CamelLinkedIn.secure_urls", null);

        final org.apache.camel.component.linkedin.api.model.Likes result = requestBodyAndHeaders("direct://GETUPDATELIKES", null, headers);

        assertNotNull("getUpdateLikes result", result);
        LOG.debug("getUpdateLikes: " + result);
    }

    // TODO provide parameter values for likeUpdate
    @Ignore
    @Test
    public void testLikeUpdate() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        // parameter type is String
        headers.put("CamelLinkedIn.update_key", null);
        // parameter type is org.apache.camel.component.linkedin.api.model.IsLiked
        headers.put("CamelLinkedIn.isliked", null);

        requestBodyAndHeaders("direct://LIKEUPDATE", null, headers);
    }

    // TODO provide parameter values for removeGroupMembership
    @Ignore
    @Test
    public void testRemoveGroupMembership() throws Exception {
        // using long message body for single parameter "group_id"
        requestBody("direct://REMOVEGROUPMEMBERSHIP", 0L);
    }

    // TODO provide parameter values for removeGroupSuggestion
    @Ignore
    @Test
    public void testRemoveGroupSuggestion() throws Exception {
        // using long message body for single parameter "group_id"
        requestBody("direct://REMOVEGROUPSUGGESTION", 0L);
    }

    // TODO provide parameter values for removeJobBookmark
    @Ignore
    @Test
    public void testRemoveJobBookmark() throws Exception {
        // using long message body for single parameter "job_id"
        requestBody("direct://REMOVEJOBBOOKMARK", 0L);
    }

    // TODO provide parameter values for share
    @Ignore
    @Test
    public void testShare() throws Exception {
        // using org.apache.camel.component.linkedin.api.model.Share message body for single parameter "share"
        final org.apache.camel.component.linkedin.api.model.Update result = requestBody("direct://SHARE", null);

        assertNotNull("share result", result);
        LOG.debug("share: " + result);
    }

    // TODO provide parameter values for stopFollowingCompany
    @Ignore
    @Test
    public void testStopFollowingCompany() throws Exception {
        // using long message body for single parameter "company_id"
        requestBody("direct://STOPFOLLOWINGCOMPANY", 0L);
    }

    // TODO provide parameter values for updateGroupMembership
    @Ignore
    @Test
    public void testUpdateGroupMembership() throws Exception {
        final Map<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelLinkedIn.group_id", 0L);
        // parameter type is org.apache.camel.component.linkedin.api.model.GroupMembership
        headers.put("CamelLinkedIn.groupmembership", null);

        requestBodyAndHeaders("direct://UPDATEGROUPMEMBERSHIP", null, headers);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            public void configure() {
                // test route for addActivity
                from("direct://ADDACTIVITY")
                    .to("linkedin://" + PATH_PREFIX + "/addActivity?inBody=activity");

                // test route for addGroupMembership
                from("direct://ADDGROUPMEMBERSHIP")
                    .to("linkedin://" + PATH_PREFIX + "/addGroupMembership?inBody=groupmembership");

                // test route for addInvite
                from("direct://ADDINVITE")
                    .to("linkedin://" + PATH_PREFIX + "/addInvite?inBody=mailboxitem");

                // test route for addJobBookmark
                from("direct://ADDJOBBOOKMARK")
                    .to("linkedin://" + PATH_PREFIX + "/addJobBookmark?inBody=jobbookmark");

                // test route for addUpdateComment
                from("direct://ADDUPDATECOMMENT")
                    .to("linkedin://" + PATH_PREFIX + "/addUpdateComment");

                // test route for followCompany
                from("direct://FOLLOWCOMPANY")
                    .to("linkedin://" + PATH_PREFIX + "/followCompany?inBody=company");

                // test route for getConnections
                from("direct://GETCONNECTIONS")
                    .to("linkedin://" + PATH_PREFIX + "/getConnections");

                // test consumer route for getConnections
                from("linkedin://" + PATH_PREFIX + "/getConnections")
                    .to("mock://GETCONNECTIONS");

                // test route for getConnectionsById
                from("direct://GETCONNECTIONSBYID")
                    .to("linkedin://" + PATH_PREFIX + "/getConnectionsById");

                // test route for getConnectionsByUrl
                from("direct://GETCONNECTIONSBYURL")
                    .to("linkedin://" + PATH_PREFIX + "/getConnectionsByUrl");

                // test route for getFollowedCompanies
                from("direct://GETFOLLOWEDCOMPANIES")
                    .to("linkedin://" + PATH_PREFIX + "/getFollowedCompanies?inBody=fields");

                // test route for getGroupMembershipSettings
                from("direct://GETGROUPMEMBERSHIPSETTINGS")
                    .to("linkedin://" + PATH_PREFIX + "/getGroupMembershipSettings");

                // test route for getGroupMemberships
                from("direct://GETGROUPMEMBERSHIPS")
                    .to("linkedin://" + PATH_PREFIX + "/getGroupMemberships");

                // test route for getJobBookmarks
                from("direct://GETJOBBOOKMARKS")
                    .to("linkedin://" + PATH_PREFIX + "/getJobBookmarks");

                // test route for getNetworkStats
                from("direct://GETNETWORKSTATS")
                    .to("linkedin://" + PATH_PREFIX + "/getNetworkStats");

                // test route for getNetworkUpdates
                from("direct://GETNETWORKUPDATES")
                    .to("linkedin://" + PATH_PREFIX + "/getNetworkUpdates");

                // test route for getNetworkUpdatesById
                from("direct://GETNETWORKUPDATESBYID")
                    .to("linkedin://" + PATH_PREFIX + "/getNetworkUpdatesById");

                // test route for getPerson
                from("direct://GETPERSON")
                    .to("linkedin://" + PATH_PREFIX + "/getPerson");

                // test route for getPersonById
                from("direct://GETPERSONBYID")
                    .to("linkedin://" + PATH_PREFIX + "/getPersonById");

                // test route for getPersonByUrl
                from("direct://GETPERSONBYURL")
                    .to("linkedin://" + PATH_PREFIX + "/getPersonByUrl");

                // test route for getPosts
                from("direct://GETPOSTS")
                    .to("linkedin://" + PATH_PREFIX + "/getPosts");

                // test route for getSuggestedCompanies
                from("direct://GETSUGGESTEDCOMPANIES")
                    .to("linkedin://" + PATH_PREFIX + "/getSuggestedCompanies?inBody=fields");

                // test route for getSuggestedGroupPosts
                from("direct://GETSUGGESTEDGROUPPOSTS")
                    .to("linkedin://" + PATH_PREFIX + "/getSuggestedGroupPosts");

                // test route for getSuggestedGroups
                from("direct://GETSUGGESTEDGROUPS")
                    .to("linkedin://" + PATH_PREFIX + "/getSuggestedGroups?inBody=fields");

                // test route for getSuggestedJobs
                from("direct://GETSUGGESTEDJOBS")
                    .to("linkedin://" + PATH_PREFIX + "/getSuggestedJobs?inBody=fields");

                // test route for getUpdateComments
                from("direct://GETUPDATECOMMENTS")
                    .to("linkedin://" + PATH_PREFIX + "/getUpdateComments");

                // test route for getUpdateLikes
                from("direct://GETUPDATELIKES")
                    .to("linkedin://" + PATH_PREFIX + "/getUpdateLikes");

                // test route for likeUpdate
                from("direct://LIKEUPDATE")
                    .to("linkedin://" + PATH_PREFIX + "/likeUpdate");

                // test route for removeGroupMembership
                from("direct://REMOVEGROUPMEMBERSHIP")
                    .to("linkedin://" + PATH_PREFIX + "/removeGroupMembership?inBody=group_id");

                // test route for removeGroupSuggestion
                from("direct://REMOVEGROUPSUGGESTION")
                    .to("linkedin://" + PATH_PREFIX + "/removeGroupSuggestion?inBody=group_id");

                // test route for removeJobBookmark
                from("direct://REMOVEJOBBOOKMARK")
                    .to("linkedin://" + PATH_PREFIX + "/removeJobBookmark?inBody=job_id");

                // test route for share
                from("direct://SHARE")
                    .to("linkedin://" + PATH_PREFIX + "/share?inBody=share");

                // test route for stopFollowingCompany
                from("direct://STOPFOLLOWINGCOMPANY")
                    .to("linkedin://" + PATH_PREFIX + "/stopFollowingCompany?inBody=company_id");

                // test route for updateGroupMembership
                from("direct://UPDATEGROUPMEMBERSHIP")
                    .to("linkedin://" + PATH_PREFIX + "/updateGroupMembership");

            }
        };
    }
}
