/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.util;

import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;

public class Colors {
    static Image image;
    static Image newImage;
    static BufferedImage clearFill;
    static Color buttonBg;
    static Color bg;

    public static Image getImage() {
        return newImage;
    }

    public static BufferedImage getClearFill() {
        return clearFill;
    }

    public static void drawStipples(Graphics g, JComponent c, Color bg) {
        g.setColor(Colors.dark(bg, 103));
        int height = c.getHeight();
        for (int i = 0; i < height; i += 3) {
            g.drawLine(0, i, c.getWidth() - 1, i);
            g.drawLine(0, ++i, c.getWidth() - 1, i);
        }
    }

    static Color handlesinglepixel(int x, int y, int pixel, Color c) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return Colors.liquidAlpha(c, new Color(red, green, blue, alpha));
    }

    public static void getPixels() {
        SkinImageCache sic = SkinImageCache.getInstance();
        image = sic.getAutomaticImage("button.png");
        clearFill = sic.getBufferedImage("clear_fill.png");
        int x = 0;
        int y = 0;
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        newImage = new BufferedImage(w, h, 6);
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        Graphics g = newImage.getGraphics();
        Color colourWith = null;
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                if (i == 0 || i == 117) {
                    colourWith = bg;
                } else if (i == 39 || i == 156) {
                    colourWith = buttonBg;
                } else if (i == 78) {
                    colourWith = Colors.dark(buttonBg, 115);
                }
                g.setColor(Colors.handlesinglepixel(x + i, y + j, pixels[j * w + i], colourWith));
                g.drawLine(x + i, y + j, x + i, y + j);
            }
        }
    }

    public static Color dark(Color c, int factor) {
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        if (factor <= 0 || c.getAlpha() < 255) {
            return c;
        }
        if (factor < 100) {
            return Colors.light(c, 10000 / factor);
        }
        int vi = (int)(hsv[2] * 255.0f);
        vi = 100 * vi / factor;
        float v = (float)vi / 255.0f;
        return Color.getHSBColor(hsv[0], hsv[1], v);
    }

    public static Color light(Color c, int factor) {
        if (factor <= 0) {
            return c;
        }
        if (factor < 100) {
            return Colors.dark(c, 10000 / factor);
        }
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float s = hsv[1];
        float v = hsv[2];
        System.out.print("LIGHT V : " + v);
        v = (float)factor * v / 100.0f;
        if (v > 1.0f) {
            v = 1.0f;
        }
        if (v > 255.0f) {
            if ((s -= v - 255.0f) < 0.0f) {
                s = 0.0f;
            }
            v = 255.0f;
        }
        return Color.getHSBColor(hsv[0], hsv[1], v);
    }

    public static Color liquidAlpha(Color c, Color bg) {
        boolean blend = false;
        int srcR = c.getRed();
        int srcG = c.getGreen();
        int srcB = c.getBlue();
        int alpha = bg.getAlpha();
        int delta = 255 - bg.getRed();
        int destR = (srcR += 20) - delta;
        int destG = (srcG += 20) - delta;
        int destB = (srcB += 20) - delta;
        if (destR < 0) {
            destR = 0;
        }
        if (destG < 0) {
            destG = 0;
        }
        if (destB < 0) {
            destB = 0;
        }
        if (destR > 255) {
            destR = 255;
        }
        if (destG > 255) {
            destG = 255;
        }
        if (destB > 255) {
            destB = 255;
        }
        if (blend && alpha != 255 && alpha != 0) {
            float srcPercent = (float)alpha / 255.0f;
            float destPercent = 1.0f - srcPercent;
            destR = (int)(srcPercent * (float)destR + destPercent * (float)bg.getRed());
            destG = (int)(srcPercent * (float)destG + destPercent * (float)bg.getGreen());
            destB = (int)(srcPercent * (float)destB + destPercent * (float)bg.getBlue());
            alpha = 255;
        }
        return new Color(destR, destG, destB, alpha);
    }

    static {
        buttonBg = new Color(215, 231, 249);
        bg = new Color(246, 245, 244);
    }
}

