/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class HueShiftColorScheme
extends BaseColorScheme {
    private double hueShiftFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme origScheme;

    public HueShiftColorScheme(ColorScheme origScheme, double hueShiftFactor) {
        this.hueShiftFactor = hueShiftFactor;
        this.origScheme = origScheme;
        this.foregroundColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getForegroundColor(), this.hueShiftFactor / 2.0);
        this.mainUltraDarkColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getUltraDarkColor(), this.hueShiftFactor);
        this.mainDarkColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getDarkColor(), this.hueShiftFactor);
        this.mainMidColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getMidColor(), this.hueShiftFactor);
        this.mainLightColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getLightColor(), this.hueShiftFactor);
        this.mainExtraLightColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getExtraLightColor(), this.hueShiftFactor);
        this.mainUltraLightColor = SubstanceColorUtilities.getHueShiftedColor(origScheme.getUltraLightColor(), this.hueShiftFactor);
        this.id = this.getClass().getName() + SubstanceCoreUtilities.getSchemeId(origScheme) + ":" + this.hueShiftFactor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getHueShiftFactor() {
        return this.hueShiftFactor;
    }
}

