/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.color.SaturatedColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;

public class SubstanceSaturatedTheme
extends SubstanceWrapperTheme {
    private double saturationFactor;
    private boolean toSaturateEverything;

    SubstanceSaturatedTheme(SubstanceTheme substanceTheme, double saturationFactor, boolean toSaturateEverything) {
        super(substanceTheme, new SaturatedColorScheme(substanceTheme.getColorScheme(), saturationFactor), "Saturated " + substanceTheme.getDisplayName() + " " + (int)(100.0 * saturationFactor) + "% [" + toSaturateEverything + "]", substanceTheme.getKind());
        this.saturationFactor = saturationFactor;
        this.toSaturateEverything = toSaturateEverything;
    }

    public SubstanceTheme getBorderTheme() {
        if (this.borderTheme == null) {
            this.borderTheme = this.originalTheme.getBorderTheme().saturate(this.saturationFactor);
        }
        return this.borderTheme;
    }

    public SubstanceTheme getDefaultTheme() {
        if (this.toSaturateEverything) {
            if (this.defaultTheme == null) {
                this.defaultTheme = this.originalTheme.getDefaultTheme().saturate(this.saturationFactor);
            }
            return this.defaultTheme;
        }
        return this.originalTheme.getDefaultTheme();
    }

    public SubstanceTheme getDisabledTheme() {
        if (this.toSaturateEverything) {
            if (this.disabledTheme == null) {
                this.disabledTheme = this.originalTheme.getDisabledTheme().saturate(this.saturationFactor);
            }
            return this.disabledTheme;
        }
        return this.originalTheme.getDisabledTheme();
    }
}

