package com.redhat.installer.installation.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TomcatUtils {

    public static final String contextPath = "/conf/context.xml";

    public static Document getContextXmlDocument() throws SAXException, IOException, ParserConfigurationException{
        return getXmlDocument(Paths.get(AutomatedInstallData.getInstance().getInstallPath() + contextPath));
    }

    public static Document getXmlDocument(Path tomcatXml) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(tomcatXml.toFile());
    }

    public static Comment createInstallerComment(Document xml) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return xml.createComment(idata.langpack.getString("tomcat.installer.comment"));
    }

    public static void writeXmlDocumentToFile(Document doc, Path file) throws XPathExpressionException, TransformerException, IOException {
        BufferedWriter writeOut = null;
        // Remove whitespaces outside tags
        doc.normalize();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList) xPath.evaluate("//text()[normalize-space()='']",
                doc,
                XPathConstants.NODESET);

        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }

        // Setup pretty print options
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");

        // Return pretty print xml string
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));

        String outputString = stringWriter.toString();

        Files.write(file, outputString.getBytes());
    }

    public static Node findNodeWithAttribute(NodeList list, String attributeName, String attributeValue){
        for (int i = 0; i < list.getLength(); i++){
            Node node = list.item(i);
            if (node.hasAttributes() && node.getAttributes().getNamedItem(attributeName).getNodeValue().equals(attributeValue)){
                return node;
            }
        }
        return new DefaultNode();

    }

    public static Path getContextPath() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return Paths.get(idata.getInstallPath() + contextPath);
    }
}
