package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TomcatModifyServer;
import com.redhat.installer.tests.TestUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertTrue;
import static org.junit.Assert.assertFalse;

public class TomcatModifyServerTest extends ProcessPanelTester {

    private final String serverXml = "/tomcat/server.xml";
    private final String serverExistingCredsXml = "/tomcat/server-existing-creds.xml";
    private final String copiedXml = "/conf/server.xml";

    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
    }

    @After
    public void cleanup() throws Exception {
        if (Files.exists(Paths.get(idata.getInstallPath() + copiedXml))) {
            MockResourceBuilder.deleteFile(idata.getInstallPath() + copiedXml);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        MockResourceBuilder.copyResourceToInstall(serverXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatModifyServer.run(handler, new String[]{});
        assertCorrect(result);
    }

    @Test
    public void testExistingCredentialHandler() throws Exception {
        MockResourceBuilder.copyResourceToInstall(serverExistingCredsXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatModifyServer.run(handler, new String[]{});
        assertTrue(result);
        String newFileString = Files.lines(Paths.get(tempFolder.getRoot().getPath() + copiedXml)).collect(Collectors.joining("\n"));
        Document modifiedXml = Jsoup.parse(newFileString, "", Parser.xmlParser());
        Elements hostElements = modifiedXml.getElementsByTag("Host");
        assertFalse(hostElements.isEmpty());
        Elements addedValve = hostElements.select("Valve[className=org.kie.integration.tomcat.JACCValve]");
        assertTrue(addedValve != null && addedValve.size() == 1);
        Elements realmElements = modifiedXml.getElementsByTag("Realm");
        assertFalse(realmElements.isEmpty());
    }

    private void assertCorrect(boolean result) throws IOException {
        assertTrue(result);
        String newFileString = Files.lines(Paths.get(tempFolder.getRoot().getPath() + copiedXml)).collect(Collectors.joining("\n"));
        Document modifiedXml = Jsoup.parse(newFileString, "", Parser.xmlParser());
        Elements hostElements = modifiedXml.getElementsByTag("Host");
        assertFalse(hostElements.isEmpty());
        Elements addedValve = hostElements.select("Valve[className=org.kie.integration.tomcat.JACCValve]");
        assertTrue(addedValve != null && addedValve.size() == 1);
        Elements realmElements = modifiedXml.getElementsByTag("Realm");
        assertFalse(realmElements.isEmpty());
    }

}
