/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.server.management.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public class Constants {

    @TranslationKey(defaultValue = "")
    public static final String ContainerProcessConfigView_SaveSuccessMessage = "ContainerProcessConfigView.SaveSuccessMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerProcessConfigView_SaveErrorMessage = "ContainerProcessConfigView.SaveErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_StartScannerErrorMessage = "ContainerRulesConfigView.StartScannerErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_StopScannerErrorMessage = "ContainerRulesConfigView.StopScannerErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_ScanNowErrorMessage = "ContainerRulesConfigView.ScanNowErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_UpgradeErrorMessage = "ContainerRulesConfigView.UpgradeErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_UpgradeSuccessMessage = "ContainerRulesConfigView.UpgradeSuccessMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_Alias = "ContainerView.Alias";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_RemoveContainerSuccessMessage = "ContainerView.RemoveContainerSuccessMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_RemoveContainerErrorMessage = "ContainerView.RemoveContainerErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_StopContainerErrorMessage = "ContainerView.StopContainerErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_StartContainerErrorMessage = "ContainerView.StartContainerErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_ConfirmRemovePopupMessage = "ContainerView.ConfirmRemovePopupMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerView_ConfirmRemovePopupTitle = "ContainerView.ConfirmRemovePopupTitle";
    
    @TranslationKey(defaultValue = "")
    public static final String ContainerView_ActivateButton = "ContainerView.ActivateButton";
    
    @TranslationKey(defaultValue = "")
    public static final String ContainerView_DeactivateButton = "ContainerView.DectivateButton";

    @TranslationKey(defaultValue = "")
    public static final String CopyPopupView_TemplateNameLabelText = "CopyPopupView.TemplateNameLabelText";

    @TranslationKey(defaultValue = "")
    public static final String CopyPopupView_CopyServerTemplatePopupTitle = "CopyPopupView.CopyServerTemplatePopupTitle";

    @TranslationKey(defaultValue = "")
    public static final String CopyPopupView_TemplateNameEmptyMessage = "CopyPopupView.TemplateNameEmptyMessage";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_CopyTemplateErrorMessage = "ServerTemplateView.CopyTemplateErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_RemoveTemplateErrorMessage = "ServerTemplateView.RemoveTemplateErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_RuleCheckBoxText = "ServerTemplateView.RuleCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_ProcessCheckBoxText = "ServerTemplateView.ProcessCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_PlanningCheckBoxText = "ServerTemplateView.PlanningCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_TemplateRemovePopupText = "ServerTemplateView.TemplateRemovePopupText";

    @TranslationKey(defaultValue = "")
    public static final String ServerTemplateView_TemplateRemovePopupTitle = "ServerTemplateView.TemplateRemovePopupTitle";

    @TranslationKey(defaultValue = "")
    public static final String ServerNavigationView_TitleText = "ServerNavigationView.TitleText";

    @TranslationKey(defaultValue = "")
    public static final String ArtifactListWidgetView_SelectColumnLabel = "ArtifactListWidgetView.SelectColumnLabel";

    @TranslationKey(defaultValue = "")
    public static final String NotificationView_TitleText = "NotificationView.TitleText";

    @TranslationKey(defaultValue = "")
    public static final String ProcessConfigView_ConfigPageTitle = "ProcessConfigView.ConfigPageTitle";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_InvalidErrorMessage = "NewContainerFormView.InvalidErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_ProductionModeSupportsDoesntSnapshots = "NewContainerFormView.ProductionModeSupportsDoesntSnapshots";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_NewContainerWizardTitle = "NewContainerFormView.NewContainerWizardTitle";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_NewContainerWizardSaveSuccess = "NewContainerFormView.NewContainerWizardSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_NewContainerWizardSaveError = "NewContainerFormView.NewContainerWizardSaveError";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_StartContainerText = "NewContainerFormView.StartContainerText";

    @TranslationKey(defaultValue = "")
    public static final String NewContainerFormView_TitleText = "NewContainerFormView.TitleText";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_InvalidErrorMessage = "NewTemplateView.InvalidErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_NewServerTemplateWizardTitle = "NewTemplateView.NewServerTemplateWizardTitle";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_NewServerTemplateWizardSaveSuccess = "NewTemplateView.NewServerTemplateWizardSaveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_NewServerTemplateWizardSaveError = "NewTemplateView.NewServerTemplateWizardSaveError";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_RuleCheckBoxText = "NewTemplateView.RuleCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_ProcessCheckBoxText = "NewTemplateView.ProcessCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_PlanningCheckBoxText = "NewTemplateView.PlanningCheckBoxText";

    @TranslationKey(defaultValue = "")
    public static final String NewTemplateView_TitleText = "NewTemplateView.TitleText";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_VersionTextBoxPlaceholder = "ContainerRulesConfigView.VersionTextBoxPlaceholder";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_IntervalTextBoxPlaceholder = "ContainerRulesConfigView.IntervalTextBoxPlaceholder";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_IntervalTextBoxDataOriginalTitle = "ContainerRulesConfigView.IntervalTextBoxDataOriginalTitle";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_Milliseconds = "ContainerRulesConfigView.Milliseconds";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_Seconds = "ContainerRulesConfigView.Seconds";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_Minutes = "ContainerRulesConfigView.Minutes";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_Hours = "ContainerRulesConfigView.Hours";

    @TranslationKey(defaultValue = "")
    public static final String ContainerRulesConfigView_Days = "ContainerRulesConfigView.Days";

    @TranslationKey(defaultValue = "")
    public static final String ClientMergeMode_KeepAll = "ClientMergeMode.KeepAll";

    @TranslationKey(defaultValue = "")
    public static final String ClientMergeMode_OverrideAll = "ClientMergeMode.OverrideAll";

    @TranslationKey(defaultValue = "")
    public static final String ClientMergeMode_OverrideEmpty = "ClientMergeMode.OverrideEmpty";

    @TranslationKey(defaultValue = "")
    public static final String ClientMergeMode_MergeCollections = "ClientMergeMode.MergeCollections";

    @TranslationKey(defaultValue = "")
    public static final String ClientRuntimeStrategy_Singleton = "ClientRuntimeStrategy.Singleton";

    @TranslationKey(defaultValue = "")
    public static final String ClientRuntimeStrategy_PerRequest = "ClientRuntimeStrategy.PerRequest";

    @TranslationKey(defaultValue = "")
    public static final String ClientRuntimeStrategy_PerProcessInstance = "ClientRuntimeStrategy.PerProcessInstance";

    @TranslationKey(defaultValue = "")
    public static final String ClientRuntimeStrategy_PerCase = "ClientRuntimeStrategy.PerCase";

    @TranslationKey(defaultValue = "")
    public static final String RemoteView_RemoteInstanceRemoveSuccess = "RemoteView.RemoteInstanceRemoveSuccess";

    @TranslationKey(defaultValue = "")
    public static final String RemoteView_RemoteInstanceRemoveError = "RemoteView.RemoteInstanceRemoveError";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_StartContainer = "ClientContainerRuntimeOperation.StartContainer";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_StopContainer = "ClientContainerRuntimeOperation.StopContainer";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_UpgradeContainer = "ClientContainerRuntimeOperation.UpgradeContainer";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_Scan = "ClientContainerRuntimeOperation.Scan";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_StartScanner = "ClientContainerRuntimeOperation.StartScanner";

    @TranslationKey(defaultValue = "")
    public static final String ClientContainerRuntimeOperation_StopScanner = "ClientContainerRuntimeOperation.StopScanner";

    @TranslationKey(defaultValue = "")
    public static final String ContainerUpdateEvent_ErrorMessage = "ContainerUpdateEvent.ErrorMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerUpdateEvent_WarnMessage = "ContainerUpdateEvent.WarnMessage";

    @TranslationKey(defaultValue = "")
    public static final String ContainerUpdateEvent_SuccessMessage = "ContainerUpdateEvent.SuccessMessage";

}
