/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.LiquidInternalFrameTitlePane;
import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class LiquidDesktopIconUI
extends BasicDesktopIconUI {
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    protected JComponent iconPane;
    MouseInputListener mouseInputListener;

    public static ComponentUI createUI(JComponent c) {
        return new LiquidDesktopIconUI();
    }

    public void installUI(JComponent c) {
        DesktopManager desktopManager;
        JDesktopPane desktop;
        this.desktopIcon = (JInternalFrame.JDesktopIcon)c;
        this.frame = this.desktopIcon.getInternalFrame();
        this.installDefaults();
        this.installComponents();
        JInternalFrame f = this.desktopIcon.getInternalFrame();
        if (f.isIcon() && f.getParent() == null && (desktop = this.desktopIcon.getDesktopPane()) != null && (desktopManager = desktop.getDesktopManager()) instanceof DefaultDesktopManager) {
            desktopManager.iconifyFrame(f);
        }
        this.installListeners();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent c) {
        DesktopManager desktopManager;
        JDesktopPane desktop;
        this.uninstallDefaults();
        this.uninstallComponents();
        JInternalFrame f = this.desktopIcon.getInternalFrame();
        if (f.isIcon() && (desktop = this.desktopIcon.getDesktopPane()) != null && (desktopManager = desktop.getDesktopManager()) instanceof DefaultDesktopManager) {
            f.putClientProperty("wasIconOnce", null);
            this.desktopIcon.setLocation(Integer.MIN_VALUE, 0);
        }
        this.uninstallListeners();
        this.frame = null;
        this.desktopIcon = null;
    }

    protected void installComponents() {
        this.iconPane = new LiquidInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
        this.desktopIcon.setToolTipText(this.frame.getTitle());
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.iconPane);
        this.desktopIcon.setLayout(null);
        this.iconPane = null;
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.addMouseListener(this.mouseInputListener);
    }

    protected void uninstallListeners() {
        this.desktopIcon.removeMouseMotionListener(this.mouseInputListener);
        this.desktopIcon.removeMouseListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void installDefaults() {
        this.desktopIcon.setOpaque(true);
        if (LiquidLookAndFeel.winDecoPanther) {
            this.desktopIcon.setBorder(UIManager.getBorder("RootPane.frameBorder"));
        } else {
            this.desktopIcon.setBorder(new LiquidInternalFrameBorder());
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.desktopIcon);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension dim = new Dimension(this.iconPane.getMinimumSize());
        Border border = this.frame.getBorder();
        if (border != null) {
            dim.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        return dim;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Insets getInsets(JComponent c) {
        JInternalFrame iframe = this.desktopIcon.getInternalFrame();
        Border border = iframe.getBorder();
        if (border != null) {
            return border.getBorderInsets(iframe);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public class MouseInputHandler
    extends MouseInputAdapter {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent e) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            JDesktopPane d = LiquidDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (d != null) {
                DesktopManager dm = d.getDesktopManager();
                dm.endDraggingFrame(LiquidDesktopIconUI.this.desktopIcon);
            }
        }

        public void mousePressed(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.__x = e.getX();
            this.__y = e.getY();
            this._x = p.x;
            this._y = p.y;
            this.startingBounds = LiquidDesktopIconUI.this.desktopIcon.getBounds();
            JDesktopPane d = LiquidDesktopIconUI.this.desktopIcon.getDesktopPane();
            if (d != null) {
                DesktopManager dm = d.getDesktopManager();
                dm.beginDraggingFrame(LiquidDesktopIconUI.this.desktopIcon);
            }
            try {
                LiquidDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException e1) {
                // empty catch block
            }
            if (LiquidDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)LiquidDesktopIconUI.this.desktopIcon.getParent()).moveToFront(LiquidDesktopIconUI.this.desktopIcon);
            }
            if (e.getClickCount() > 1 && LiquidDesktopIconUI.this.frame.isIconifiable() && LiquidDesktopIconUI.this.frame.isIcon()) {
                LiquidDesktopIconUI.this.deiconize();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            JDesktopPane d;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            Insets i = LiquidDesktopIconUI.this.desktopIcon.getInsets();
            int pWidth = ((JComponent)LiquidDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int pHeight = ((JComponent)LiquidDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            if (this.startingBounds == null) {
                return;
            }
            int newX = this.startingBounds.x - (this._x - p.x);
            int newY = this.startingBounds.y - (this._y - p.y);
            if (newX + i.left <= -this.__x) {
                newX = -this.__x - i.left;
            }
            if (newY + i.top <= -this.__y) {
                newY = -this.__y - i.top;
            }
            if (newX + this.__x + i.right > pWidth) {
                newX = pWidth - this.__x - i.right;
            }
            if (newY + this.__y + i.bottom > pHeight) {
                newY = pHeight - this.__y - i.bottom;
            }
            if ((d = LiquidDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager dm = d.getDesktopManager();
                dm.dragFrame(LiquidDesktopIconUI.this.desktopIcon, newX, newY);
            } else {
                this.moveAndRepaint(LiquidDesktopIconUI.this.desktopIcon, newX, newY, LiquidDesktopIconUI.this.desktopIcon.getWidth(), LiquidDesktopIconUI.this.desktopIcon.getHeight());
            }
        }

        public void moveAndRepaint(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            Rectangle r = f.getBounds();
            f.setBounds(newX, newY, newWidth, newHeight);
            SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
            f.getParent().repaint(r.x, r.y, r.width, r.height);
        }
    }
}

