package com.izforge.izpack.panels;

import com.izforge.izpack.gui.UiResources;

import javax.swing.*;
import java.awt.*;

/**
 * Created by dsoukhov on 24/01/17.
 */
public class JFocusPanel extends JPanel {

    private Color clear = UIManager.getColor("Panel.background");
    private Color focus = UiResources.blueFocus;
    private boolean toSet = true;
    private boolean toClear = false;
    private JComponent component;

    public JFocusPanel(JComponent c) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 1, 0, 0);
        gbc.weightx = gbc.weighty = 1;
        gbc.fill = GridBagConstraints.BOTH;
        component = c;
        this.setBorder(BorderFactory.createLineBorder(clear));
        this.add(c, gbc);
    }

    public void setFocusBorder(boolean set){
        if(set && toSet) {
            this.setBorder(BorderFactory.createLineBorder(focus));
            toSet = false;
            toClear = true;
        }
        if(!set && toClear){
            this.setBorder(BorderFactory.createLineBorder(clear));
            toClear = false;
            toSet = true;
        }
    }

    public JComponent getComponent() {
        return component;
    }
}
