package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.io.File;
import java.util.Collection;

@RunWith(Parameterized.class)
public class PatcherFactoryCorrectImplClassTest extends BaseClientPatcherTest {

    // we just need some existing dir for the purpose of this test
    private static final File distributionRoot = tmpDir;
    // dir that contains dummy patch contents to satisfy the PatcherFactory
    private static final File patchBaseDir = getCPResourceAsFile("/patcher-factory-test/patch-dir");

    @Parameterized.Parameters(name = "{index}: {0}-{1}")
    public static Collection<Object[]> data() {
        return Lists.newArrayList(new Object[][]{
                // BRMS distribution types
                // will return NestedDirInBundlePatcher because it assumes the distro root is dir with the WARs and not the
                // EAP_HOME. This is special case for EAP distro
                {DistributionType.RHPAM_EAP7X_BC, TargetProduct.RHPAM, GeneralDistributionPatcher.class}
        });
    }

    @Parameterized.Parameter(0)
    public DistributionType distroType;

    @Parameterized.Parameter(1)
    public TargetProduct product;

    @Parameterized.Parameter(2)
    public Class<?> expectedImplClass;

    @Test
    public void shouldReturnCorrectImplClassForSpecifiedDistribution() {
        ClientPatcherConfig config = new ClientPatcherConfig();
        config.setDistributionType(distroType);
        config.setProduct(product);
        config.setDistributionRoot(distributionRoot);
        config.setPatchBasedir(patchBaseDir);
        DistributionPatcher patcher = PatcherFactory.newDistributionPatcher(config);
        Assert.assertTrue("Unexpected patcher impl class returned by PatcherFactory!",
                expectedImplClass.isAssignableFrom(patcher.getClass()));
    }

}
