package org.jboss.brmsbpmsuite.patching.client;

import org.junit.Test;
import org.osgi.framework.Version;

import java.util.Properties;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

public class VersionCheckerProviderTest {

    @Test
    public void loadVersionCheckerFromPropertiesFile() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(patcheableVersion), is(true));
    }

    @Test(expected = InvalidVersionException.class)
    public void throwExceptionWhenPropertiesAreNotFound() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.createInstance(new Properties());

        versionChecker.isValidForVersion(patcheableVersion);
    }

    @Test(expected = IllegalArgumentException.class)
    public void throwExceptionWhenVersionIsMalformed() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        Properties versionProperties = new Properties();
        versionProperties.put("version-range-lower-limit", "a-bad-version");
        versionProperties.put("version-range-upper-limit", "6.2.1.Final-redhat-1");
        VersionChecker versionChecker = VersionCheckerProvider.createInstance(versionProperties);

        versionChecker.isValidForVersion(patcheableVersion);
    }

}