package org.jboss.brmsbpmsuite.patching.integrationtests.model.distribution;

import java.io.File;

/**
 * Class representing product distribution.
 */
public class ProductDistribution extends Distribution {

    public ProductDistribution(final File directory, final DistributionType type) {
        super(directory, type);
    }

    @Override
    public File getContentRootDirectory() {
        final File bundleRootDirectory = getBundleRootDirectory();
        final String bundleRootDirName = isValidBundleRootSubdirectory(bundleRootDirectory)
                ? bundleRootDirectory.getName() : null;
        return new File(getBaseDirectory().getPath() + File.separator + getType().getRelativePath(
                RelativePathType.PATH_WITHIN_DISTRIBUTION, bundleRootDirName));
    }

    private boolean isValidBundleRootSubdirectory(final File bundleRootDirectory) {
        // need to specify top-level directory (like 'jboss-eap-7.1') only if it is present in the distribution
        return bundleRootDirectory != null && !bundleRootDirectory.equals(getBaseDirectory());
    }
}
