package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.util.TomcatUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;

public class TomcatAddResource {
    protected static AutomatedInstallData idata;
    protected static AbstractUIProcessHandler mHandler;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        List<String> argList= new ArrayList<>(Arrays.asList(args));
        return addTomcatResource(argList);
    }

    protected static boolean addTomcatResource(List<String> argList) {
        try{
            Document xml = TomcatUtils.getContextXmlDocument();
            xml.getDocumentElement().appendChild(TomcatUtils.createInstallerComment(xml));
            addResourceToContext(xml, argList);
            TomcatUtils.writeXmlDocumentToFile(xml, TomcatUtils.getContextPath());
        } catch (SAXException | ParserConfigurationException | IOException | TransformerException | XPathExpressionException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.datasource.failed"), true);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.datasource.success"), false);
        return true;
    }

    private static void addResourceToContext(Document xml, List<String> argList) {
        Element resource = xml.createElement("Resource");
        Map<String,String> resourceAttributes = createResourceAttributesMap(argList);
        for (Map.Entry<String,String> attribute : resourceAttributes.entrySet()){
            resource.setAttribute(attribute.getKey(), attribute.getValue());
        }
        xml.getDocumentElement().appendChild(resource);
    }

    private static Map<String, String> createResourceAttributesMap(List<String> argList) {
        Map<String,String> attributeMap = new HashMap<>();
        for (String keyValue : argList) {
            final int maxSplitParts = 2;
            String[] split = keyValue.split("=", maxSplitParts);
            attributeMap.put(split[0], split[1]);
        }
        return attributeMap;
    }

}