package com.redhat.installer.tests.asconfiguration.jsf;

import com.redhat.installer.asconfiguration.jsf.JsfUtils;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

/**
 * Created by jjavier on 29/09/16.
 */

public class JsfUtilsTest {
    @Test
    public void testCleanedVerTrimmed() throws Exception{
        String result = JsfUtils.cleanedVer("2.1-SNAPSHOT");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerUntrimmedShort() throws Exception{
        String result = JsfUtils.cleanedVer("2.1");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerWhtieSpace() throws Exception{
        String result = JsfUtils.cleanedVer("   2.1   ");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerUntrimmedLong() throws Exception{
        String result = JsfUtils.cleanedVer("2.2.9");
        assertEquals("2.2.9", result);
    }

    @Test
    public void testCleanedVerInvalidString() throws Exception{
        String result = JsfUtils.cleanedVer("SNAPSHOT");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerInvalidVersion() throws Exception{
        String result = JsfUtils.cleanedVer("1.0");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerTooLong() throws Exception{
        String result = JsfUtils.cleanedVer("2.2.222");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerDecorator1() throws Exception{
        String result = JsfUtils.cleanedVer("2.1asdf");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerDecorator2() throws Exception{
        String result = JsfUtils.cleanedVer("2.1 asdf");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerDecorator3() throws Exception{
        String result = JsfUtils.cleanedVer("2.1-asdf");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerDecorator4() throws Exception{
        String result = JsfUtils.cleanedVer("2.1_asdf");
        assertEquals("2.1", result);
    }

    @Test
    public void testCleanedVerEmpty() throws Exception{
        String result = JsfUtils.cleanedVer("");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerDecoratorEndWithDelim() throws Exception{
        String result = JsfUtils.cleanedVer("2.2.snapshot.");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerEndWithDelim1() throws Exception{
        String result = JsfUtils.cleanedVer("2.2.");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerEndWithDelim2() throws Exception{
        String result = JsfUtils.cleanedVer("2.2_");
        assertEquals("", result);
    }

    @Test
    public void testCleanedVerEndWithDelim3() throws Exception{
        String result = JsfUtils.cleanedVer("2.2-");
        assertEquals("", result);
    }

}
