/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.agriculture.dag.agorha.util;

import fr.gouv.agriculture.dag.agorha.util.DateUtils;
import fr.gouv.agriculture.dag.agorha.util.DureeComponent;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class Periode
implements Serializable,
Comparable<Periode> {
    private static final String DATE_PATTERN = "dd/MM/yyyy";
    private static final String[] DATE_PARSE_PATTERNS = new String[]{"dd/MM/yyyy"};
    private static final long serialVersionUID = -3505978166365206567L;
    private Date dateDebut;
    private Date dateFin;
    private DureeComponent duree;
    private DureeComponent dureeComptable;
    private static final int STATE_INI = 0;
    private static final int STATE_READ_DATE_DEBUT = 1;
    private static final int STATE_READ_DATE_FIN = 2;

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static Collection<Periode> partitionMaximale(Periode periodeReference, Collection<Periode> periodes) {
        ArrayList<PeriodDate> periodDates = new ArrayList<PeriodDate>(2 * periodes.size());
        for (Periode periode : periodes) {
            Date fin;
            Date debut = periode.getDateDebut();
            if (debut == null || debut.before(periodeReference.getDateDebut())) {
                debut = periodeReference.getDateDebut();
            }
            if ((fin = periode.getDateFin()) == null || fin.after(periodeReference.getDateFin())) {
                fin = periodeReference.getDateFin();
            }
            periode = new Periode(debut, fin);
            periodDates.add(new PeriodDate(debut, true, periode));
            periodDates.add(new PeriodDate(fin, false, periode));
        }
        return Periode.partitionMaximalePeriodeDates(periodDates);
    }

    public static void partitionne(Periode periodeReference, Collection<Periode> periodes) {
        Collection<Periode> partitionMaximale = Periode.partitionMaximale(periodeReference, periodes);
        periodes.clear();
        periodes.addAll(partitionMaximale);
    }

    public static Periode valueOf(String periodeExpression) throws ParseException {
        if (Periode.isEmpty(periodeExpression)) {
            throw new IllegalArgumentException("periodExpression est null ou vide");
        }
        int state = 0;
        String dateDebutS = "";
        String dateFinS = "";
        StringTokenizer tokenizer = new StringTokenizer(periodeExpression, "-", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (state) {
                case 0: {
                    if ("-".equals(token)) {
                        state = 1;
                        break;
                    }
                    dateDebutS = token;
                    break;
                }
                case 1: {
                    if ("-".equals(token)) {
                        throw new ParseException("Expression invalide: " + periodeExpression + ". Format correct: [" + DATE_PATTERN + "]-[" + DATE_PATTERN + "]", 0);
                    }
                    dateFinS = token;
                    state = 2;
                    break;
                }
                case 2: {
                    throw new ParseException("Expression invalide: " + periodeExpression + ". Format correct: [" + DATE_PATTERN + "]-[" + DATE_PATTERN + "]", 0);
                }
            }
        }
        Date dateDebut = null;
        if (!Periode.isEmpty(dateDebutS)) {
            dateDebut = DateUtils.parseDate(dateDebutS, DATE_PARSE_PATTERNS);
        }
        Date dateFin = null;
        if (!Periode.isEmpty(dateFinS)) {
            dateFin = DateUtils.parseDate(dateFinS, DATE_PARSE_PATTERNS);
        }
        return new Periode(dateDebut, dateFin);
    }

    public Periode(Date dateDebut, Date dateFin) {
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
    }

    private Periode() {
    }

    public DureeComponent getDuree() {
        if (this.duree == null) {
            this.duree = new DureeComponent(this.dateDebut, this.dateFin);
        }
        return this.duree;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Periode other = (Periode)obj;
        if (this.dateDebut == null ? other.dateDebut != null : this.dateDebut.getTime() != other.dateDebut.getTime()) {
            return false;
        }
        return !(this.dateFin == null ? other.dateFin != null : this.dateFin.getTime() != other.dateFin.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateDebut == null ? 0 : this.dateDebut.hashCode());
        result = 31 * result + (this.dateFin == null ? 0 : this.dateFin.hashCode());
        return result;
    }

    @Override
    public int compareTo(Periode periode) {
        int compareTo;
        if (periode == null) {
            throw new IllegalArgumentException("periode est null");
        }
        if (this.equals(periode)) {
            return 0;
        }
        if (this.dateDebut == null) {
            if (periode.dateDebut != null) {
                return -1;
            }
            compareTo = 0;
        } else {
            if (periode.dateDebut == null) {
                return 1;
            }
            compareTo = this.dateDebut.compareTo(periode.dateDebut);
        }
        if (compareTo != 0) {
            return compareTo;
        }
        if (this.dateFin == null) {
            if (periode.dateFin != null) {
                return 1;
            }
            return 0;
        }
        return this.dateFin.compareTo(periode.dateFin);
    }

    public boolean contains(Date date) {
        if (date == null) {
            return false;
        }
        if (this.dateDebut != null && this.dateDebut.after(date)) {
            return false;
        }
        return this.dateFin == null || !this.dateFin.before(date);
    }

    public boolean contains(Periode periode) {
        if (periode == null) {
            throw new IllegalArgumentException("periode est null");
        }
        if (periode.dateDebut == null && this.dateDebut != null) {
            return false;
        }
        if (periode.dateFin == null && this.dateFin != null) {
            return false;
        }
        return this.contains(periode.dateDebut) && this.contains(periode.dateFin);
    }

    public boolean containsWithNull(Periode periode) {
        if (periode == null || periode.dateDebut == null && periode.dateFin == null) {
            throw new IllegalArgumentException("La periode est null ou les deux dates la composant sont null");
        }
        if (this.dateDebut == null) {
            throw new IllegalArgumentException("La periode en cours, ne peut avoir de date de debut null");
        }
        return !(periode.dateDebut != null && !DateUtils.afterEquals(this.dateDebut, periode.dateDebut) && (!DateUtils.beforeEquals(this.dateDebut, periode.dateDebut) || this.dateFin != null && !DateUtils.afterEquals(this.dateFin, periode.dateDebut)) || periode.dateFin != null && !DateUtils.beforeEquals(this.dateDebut, periode.dateFin));
    }

    public Date getDateDebut() {
        if (this.dateDebut != null) {
            Date dateDeb = new Date();
            dateDeb.setTime(this.dateDebut.getTime());
            return dateDeb;
        }
        return null;
    }

    public Date getDateFin() {
        if (this.dateFin != null) {
            Date dateFin2 = new Date();
            dateFin2.setTime(this.dateFin.getTime());
            return dateFin2;
        }
        return null;
    }

    public DureeComponent getDureeComptable() {
        if (this.dureeComptable == null) {
            this.dureeComptable = new DureeComponent(this.dateDebut, this.dateFin, 0);
        }
        return this.dureeComptable;
    }

    public boolean overlapse(Periode periode) {
        if (periode == null) {
            throw new IllegalArgumentException("periode est null");
        }
        return this.contains(periode.dateDebut) || this.contains(periode.dateFin) || periode.contains(this.dateDebut) || periode.contains(this.dateFin);
    }

    private static List<Periode> partitionMaximalePeriodeDates(List<PeriodDate> periodDates) {
        Collections.sort(periodDates);
        HashMap<Periode, Integer> periodesActives = new HashMap<Periode, Integer>();
        ArrayList<Periode> periodes = new ArrayList<Periode>(periodDates.size() / 2);
        PeriodDate currentPeriodDate = null;
        for (PeriodDate periodDate : periodDates) {
            Periode periodeMaximale;
            if (currentPeriodDate != null && !periodDate.date.equals(currentPeriodDate.date) && Periode.isDateInsideActivePeriode(periodesActives, periodDate) && periodeMaximale.dateDebut.before((periodeMaximale = Periode.buildPeriodeMaximale(currentPeriodDate, periodDate)).getDateFin())) {
                periodes.add(periodeMaximale);
            }
            currentPeriodDate = periodDate;
            Periode.updatePeriodesActives(periodesActives, currentPeriodDate);
        }
        return periodes;
    }

    private static void updatePeriodesActives(Map<Periode, Integer> periodesActives, PeriodDate currentPeriodDate) {
        Periode currentPeriode = currentPeriodDate.periode;
        if (currentPeriodDate.isDebut) {
            Integer count = periodesActives.get(currentPeriode);
            if (count == null) {
                periodesActives.put(currentPeriode, 1);
            } else {
                periodesActives.put(currentPeriode, count + 1);
            }
        } else {
            Integer count = periodesActives.get(currentPeriode);
            if ((count = Integer.valueOf(count - 1)) < 0) {
                periodesActives.remove(currentPeriode);
            } else {
                periodesActives.put(currentPeriode, count);
            }
        }
    }

    private static Periode buildPeriodeMaximale(PeriodDate currentPeriodDate, PeriodDate periodDate) {
        Periode periodeMaximale = currentPeriodDate.isDebut ? (periodDate.isDebut ? new Periode(currentPeriodDate.date, DateUtils.addDays(periodDate.date, -1)) : new Periode(currentPeriodDate.date, periodDate.date)) : (periodDate.isDebut ? new Periode(DateUtils.addDays(currentPeriodDate.date, 1), DateUtils.addDays(periodDate.date, -1)) : new Periode(DateUtils.addDays(currentPeriodDate.date, 1), periodDate.date));
        return periodeMaximale;
    }

    private static boolean isDateInsideActivePeriode(Map<Periode, Integer> periodesActives, PeriodDate periodDate) {
        boolean dateInsidePeriode = false;
        for (Periode periode : periodesActives.keySet()) {
            if (!periode.contains(periodDate.date)) continue;
            dateInsidePeriode = true;
            break;
        }
        return dateInsidePeriode;
    }

    public String toString() {
        String dateDebutFormattee = this.dateDebut == null ? "" : DateUtils.format(this.dateDebut, DATE_PATTERN);
        String dateFinFormattee = this.dateFin == null ? "" : DateUtils.format(this.dateFin, DATE_PATTERN);
        return dateDebutFormattee + "-" + dateFinFormattee;
    }

    private static class PeriodDate
    implements Comparable<PeriodDate> {
        Date date;
        boolean isDebut;
        Periode periode;

        private PeriodDate(Date date, boolean debut, Periode periode) {
            this.date = date;
            this.isDebut = debut;
            this.periode = periode;
        }

        @Override
        public int compareTo(PeriodDate other) {
            int compareDates = this.date.compareTo(other.date);
            if (compareDates == 0) {
                return this.isDebut ? -1 : (other.isDebut ? 1 : 0);
            }
            return compareDates;
        }

        public String toString() {
            return "PeriodDate{date=" + this.date + ", isDebut=" + this.isDebut + ", periode=" + this.periode + '}';
        }
    }
}

