/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.myfaces.config.util.CyclicDependencyException;
import org.apache.myfaces.config.util.Vertex;

public class DirectedAcyclicGraphVerifier {
    public static <T> void verify(Vertex<T> vertex) throws CyclicDependencyException {
        ArrayList<Vertex<T>> vertices = new ArrayList<Vertex<T>>();
        DirectedAcyclicGraphVerifier.addDependencies(vertex, vertices);
        DirectedAcyclicGraphVerifier.verify(vertices);
    }

    private static <T> void addDependencies(Vertex<T> vertex, List<Vertex<T>> vertices) {
        if (!vertices.contains(vertex)) {
            vertices.add(vertex);
            for (Vertex<T> v : vertex.getDependencies()) {
                DirectedAcyclicGraphVerifier.addDependencies(v, vertices);
            }
        }
    }

    public static <T> void verify(List<Vertex<T>> vertices) throws CyclicDependencyException {
        DirectedAcyclicGraphVerifier.resetVertices(vertices);
        for (Vertex<T> v : vertices) {
            for (Vertex<T> dv : v.getDependencies()) {
                if (vertices.contains(dv)) continue;
                throw new IllegalStateException("A dependent vertex (" + dv.getName() + ") of " + "vertex (" + v.getName() + ") was not included in the vertices list.");
            }
            v.resolveOrder();
        }
    }

    public static <T> void topologicalSort(List<Vertex<T>> vertices) throws CyclicDependencyException {
        DirectedAcyclicGraphVerifier.verify(vertices);
        Collections.sort(vertices);
    }

    public static <T> void resetVertices(List<Vertex<T>> vertices) {
        Iterator<Vertex<T>> it = vertices.iterator();
        while (it.hasNext()) {
            it.next().reset();
        }
    }

    public static <T> int findVertex(List<Vertex<T>> vertexList, String name) {
        for (int i = 0; i < vertexList.size(); ++i) {
            Vertex<T> v = vertexList.get(i);
            if (!name.equals(v.getName())) continue;
            return i;
        }
        return -1;
    }
}

