/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.server.services.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.impl.KieServerImpl;

public interface KieServerExtension {

    boolean isInitialized();

    boolean isActive();

    void init(KieServerImpl kieServer, KieServerRegistry registry);

    void destroy(KieServerImpl kieServer, KieServerRegistry registry);

    void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters);

    void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters);

    boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters);
    
    default void activateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {        
    }
    
    default void deactivateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {        
    }

    void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters);

    List<Object> getAppComponents(SupportedTransports type);

    <T> T getAppComponents(Class<T> serviceType);

    String getImplementedCapability();

    List<Object> getServices();

    String getExtensionName();

    Integer getStartOrder();
    
    default List<Message> healthCheck(boolean report) {
        List<Message> messages = new ArrayList<>();
        if (!isInitialized()) {
            messages.add(new Message(Severity.ERROR, getExtensionName() + " failed to start"));
        }
        
        return messages;
    }
    
    default void serverStarted() {
        
    }
}
