package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

/**
 * Created by dsoukhov on 02/09/16.
 */

public class JsfCombinedMsgValidator implements DataValidator {

    private String formattedMessage;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        String finalMsg = adata.getVariable("jsf.validator.combined.msg");

        if(!finalMsg.isEmpty()){
            setFormattedMessage(finalMsg+ adata.langpack.getString("usermsg.continue")+"?");
            adata.setVariable("jsf.validator.combined.msg", "");
            return Status.WARNING;
        }

        return Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public void setFormattedMessage(String message) {
        formattedMessage = message;
    }
    @Override
    public String getFormattedMessage() {
        return formattedMessage;
    }
}
