package com.redhat.installer.asconfiguration.ports.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

/**
 * Created by mvaghela on 02/10/15.
 */
public class CustomPortServerModeValidator implements DataValidator {

    private static final String ERROR = "port.custom.bindings.mode.check";
    String message = AutomatedInstallData.getInstance().langpack.getString(ERROR);

    public Status validateData(final AutomatedInstallData adata) {

        if (adata.getRules().isConditionTrue("port.decision")) {
            if (!adata.getRules().isConditionTrue("configure.standalone") && !adata.getRules().isConditionTrue("configure.domain")) {
                return Status.ERROR;
            }
        }
        return Status.OK;
    }

    public String getErrorMessageId() {
        return ERROR;
    }

    public String getFormattedMessage() {
        return message;
    }

    public String getWarningMessageId() {
        return null;
    }

    public boolean getDefaultAnswer() {
        return true;
    }
}