package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

/**
 * Creates only the ldap connection. Can be run as a separate step as desired in the ProcessPanel.
 * <p/>
 * <p/>
 * Created by thauser on 10/29/14.
 */
public class LdapConnection extends PostInstallation {

    protected static boolean installLdapConnection() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String ldapName = idata.getVariable("ldap.name");
        String ldapUrl = idata.getVariable("ldap.url");
        String ldapDn = idata.getVariable("ldap.dn");
        String ldapPlainPwd = idata.getVariable("ldap.password");
        String ldapVaultedPwd = idata.getVariable("ldap.vaulted.password");
        String ldapPwd = (ldapVaultedPwd != null) ? ldapVaultedPwd : ldapPlainPwd;
        return serverCommands.createLdapConnection(ldapName, ldapPwd, ldapUrl, ldapDn);
    }

    @Override
    protected Class getClassName() {
        return LdapConnection.class;
    }

    @Override
    protected boolean performOperation() {
        return installLdapConnection();
    }
}
