package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.*;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.AbstractUIProgressHandler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by eunderhi on 20/08/15.
 */
public class QuickstartInstaller {

    private static final String PACK_ID = "application-platform.quickstarts";
    private static final String PATH_KEY = "install.quickstarts.path";
    private static final String NAME_KEY = "quickstarts.name";
    private static final String START_KEY = "quickstarts.installation.start";
    private static final String END_KEY = "quickstarts.installation.end";

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        unpackQuickstarts(handler);
        moveQuickstartsToDirectory();
        return true;
    }

    private static void unpackQuickstarts(AbstractUIProcessHandler handler) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        AbstractUIProgressHandler progressHandler = new QuickStartHandler(handler);

        List<Pack> packBackup = new ArrayList<Pack>(idata.selectedPacks);

        idata.selectedPacks.clear();
        idata.addPackToSelected(PACK_ID);

        Unpacker unpacker = new Unpacker(idata, progressHandler);
        unpacker.run();

        idata.selectedPacks = packBackup;
        idata.addPackToSelected(PACK_ID);
    }

    private static void moveQuickstartsToDirectory() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String quickstartPath = idata.getVariable(PATH_KEY);
        String quickstartDirName = idata.getVariable(NAME_KEY);

        File quickstarts = new File(idata.getInstallPath(), quickstartDirName);
        if (!quickstarts.renameTo(new File(quickstartPath, quickstartDirName))){
            //#TODO: add an appropriate string here?
        }

    }

    private static class QuickStartHandler implements AbstractUIProgressHandler {

        AbstractUIProcessHandler handler;
        AutomatedInstallData adata;

        QuickStartHandler(AbstractUIProcessHandler handler) {
            adata = AutomatedInstallData.getInstance();
            this.handler = handler;
        }

        @Override
        public void startAction(String name, int no_of_steps) {
            String message = adata.langpack.getString(START_KEY);
            handler.logOutput(message, false);
        }

        @Override
        public void stopAction() {
            String message = adata.langpack.getString(END_KEY);
            handler.logOutput(message, false);
        }

        @Override
        public void nextStep(String step_name, int step_no, int no_of_substeps) {

        }

        @Override
        public void setSubStepNo(int no_of_substeps) {

        }

        @Override
        public void progress(int substep_no, String message) {
        }

        @Override
        public void emitNotification(String message) {

        }

        @Override
        public boolean emitWarning(String title, String message) {
            return false;
        }

        @Override
        public void emitError(String title, String message) {

        }

        @Override
        public void emitErrorAndBlockNext(String title, String message) {

        }

        @Override
        public int askQuestion(String title, String question, int choices) {
            return 0;
        }

        @Override
        public int askQuestion(String title, String question, int choices, int default_choice) {
            return 0;
        }
    }
}
