package com.redhat.installer.logging;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.CleanupClient;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

import java.io.File;
import java.util.Properties;
import java.util.Set;

public class LogIzPackVars extends SimpleInstallerListener implements CleanupClient {
    private static AutomatedInstallData idata;

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        initializeStaticVariables();
        writeIzPackVariablesToLog();
        ProcessPanelHelper.printToPanel(handler,
                String.format(idata.langpack.getString("LogIzPackVars.message"),
                        idata.getInstallPath() + File.separator + idata.getVariable("installation.logfile")),
                false);
    }

    private static void initializeStaticVariables() {
        idata = AutomatedInstallData.getInstance();
    }

    private static void writeIzPackVariablesToLog() {
        Properties allVars = idata.getVariables();
        Set<Object> keys = allVars.keySet();
        for (Object key : keys) {
            String realKey = (String) key;
            String realValue = (String) allVars.get(key);
            if (realKey.toLowerCase().contains("password")
                    || realKey.toLowerCase().contains("pwd")
                    || realKey.toLowerCase().contains("pass")) {
                // don't print password fields
                continue;
            } else if (realKey.toLowerCase().contains("system_sun_java_command")) {
                // don't print passwords when passed in as cmnd line args:
                InstallationLogger.getLogger().info(realKey + " = " + obfuscateCmdLineVariablePasswords(realValue));
            } else {
                InstallationLogger.getLogger().info(realKey + " = " + realValue);
            }
        }
    }

    /**
     * Given a comma separated list of key=value pairs, obfuscate the
     * values of all the keys that contain the words password or pwd in them.
     *
     * @param values
     * @return
     */
    public static String obfuscateCmdLineVariablePasswords(String values) {
        String reg = "((P|p)(assword|wd)=)(.*?)(,|$)";
        String ret = values.replaceAll(reg, "$1********$5");
        return ret;
    }

    @Override
    public void cleanUp() {

    }
}
