package com.redhat.installer.installation.action.defaults;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import static com.redhat.installer.installation.action.defaults.SetRhpamDefaults.*;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

public class SetRhpamDefaultsTest {

    private SetRhpamDefaults rhpamDefaultsTested;

    @Before
    public void setUp() {
        if (AutomatedInstallData.getInstance() == null) {
            new AutomatedInstallData();
        }

        RulesEngine rulesEngine = new RulesEngine(new HashMap<>(), AutomatedInstallData.getInstance());
        AutomatedInstallData.getInstance().setRules(rulesEngine);

        AutomatedInstallData.getInstance().setVariable("org.kie.server.process-server.controller", "process-server-url");
        AutomatedInstallData.getInstance().setVariable("org.kie.server.business-central.controller", "business-central-url");

        rhpamDefaultsTested = new SetRhpamDefaults();
    }

    @After
    public void tearDown() throws NoSuchFieldException, IllegalAccessException {
        Field self = AutomatedInstallData.class.getDeclaredField("self");
        self.setAccessible(true);
        self.set(null, null);
    }

    @Test
    public void shouldNotEnableBussinessCentralRolesWhenEAPConditionIsFalse() {
        AutomatedInstallData.getInstance().getRules().addCondition(define("izpack.selected.rhpam.eap", false));

        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();

        assertThat(defaults.get(ROLE_ADMINISTRATOR), is("false"));
        assertThat(defaults.get(ROLE_KIESERVER), is("true"));
        assertThat(defaults.get(ROLE_RESTALL), is("false"));
        assertThat(defaults.get(ROLE_ANALYST), is("false"));
        assertThat(defaults.get(ROLE_DEVELOPER), is("false"));
        assertThat(defaults.get(ROLE_USER), is("false"));
        assertThat(defaults.get(ROLE_MANAGER), is("false"));
        assertThat(defaults.get(ROLE_PROCESSADMIN), is("false"));
    }

    @Test
    public void shouldEnableBussinessCentralRolesWhenEAPConditionIsUndefined() {
        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();


        assertThat(defaults.get(ROLE_ADMINISTRATOR), is("true"));
        assertThat(defaults.get(ROLE_KIESERVER), is("true"));
        assertThat(defaults.get(ROLE_RESTALL), is("true"));
        assertThat(defaults.get(ROLE_ANALYST), is("false"));
        assertThat(defaults.get(ROLE_DEVELOPER), is("false"));
        assertThat(defaults.get(ROLE_USER), is("false"));
        assertThat(defaults.get(ROLE_MANAGER), is("false"));
        assertThat(defaults.get(ROLE_PROCESSADMIN), is("false"));
    }

    @Test
    public void shouldEnableBussinessCentralRolesWhenEAPConditionIsTrue() {
        AutomatedInstallData.getInstance().getRules().addCondition(define("izpack.selected.rhpam.eap", true));

        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();

        assertThat(defaults.get(ROLE_ADMINISTRATOR), is("true"));
        assertThat(defaults.get(ROLE_KIESERVER), is("true"));
        assertThat(defaults.get(ROLE_RESTALL), is("true"));
        assertThat(defaults.get(ROLE_ANALYST), is("false"));
        assertThat(defaults.get(ROLE_DEVELOPER), is("false"));
        assertThat(defaults.get(ROLE_USER), is("false"));
        assertThat(defaults.get(ROLE_MANAGER), is("false"));
        assertThat(defaults.get(ROLE_PROCESSADMIN), is("false"));
    }

    @Test
    public void shouldUseProcessServerUrlWhenOnlyProcessServerInstallConditionIsFalse() {
        AutomatedInstallData.getInstance().getRules().addCondition(define("only.process.server.install", false));

        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();

        assertThat(defaults.get("org.kie.server.controller"), is("business-central-url"));
    }

    @Test
    public void shouldUseProcessServerUrlWhenOnlyProcessServerInstallConditionIsUndefined() {
        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();

        assertThat(defaults.get("org.kie.server.controller"), is("process-server-url"));
    }

    @Test
    public void shouldUseProcessServerUrlWhenOnlyProcessServerInstallConditionIsTrue() {
        AutomatedInstallData.getInstance().getRules().addCondition(define("only.process.server.install", true));

        Map<String, String> defaults = rhpamDefaultsTested.getDefaultMap();

        assertThat(defaults.get("org.kie.server.controller"), is("process-server-url"));
    }

    private Condition define(String key, boolean value) {
        return new Condition() {
            {setId(key);}

            @Override
            public void readFromXML(IXMLElement xmlcondition) throws Exception {

            }

            @Override
            public boolean isTrue() {
                return value;
            }

            @Override
            public void makeXMLData(IXMLElement conditionRoot) {

            }
        };
    }

}