package com.redhat.installer.tests.asconfiguration.jsf;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.DataValidatorTester;
import org.junit.Before;
import org.junit.BeforeClass;

/**
 * Created by thauser on 9/30/16.
 */
public class AbstractVerifyJsfValidatorTest extends DataValidatorTester {
    protected final String combinedMsgVar = "jsf.validator.combined.msg";
    protected final String toValidateVar = "jsf.to.validate.project";
    protected final String apiPathVar = "jsfapi.input";
    protected final String implPathVar = "jsfimpl.input";


    @Before
    public void initSetUp(){
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/jsf-api-mojarra-2.2.1.jar", "/api-mojarra.jar");
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/jsf-impl-mojarra-2.2.1.jar", "/impl-mojarra.jar");
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/jsf-api-myfaces-2.2.11.jar", "/api-myfaces.jar");
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/jsf-impl-myfaces-2.2.11.jar", "/impl-myfaces.jar");
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/emptyMF.jar", "/emptyMF.jar");
        MockResourceBuilder.copyResourceToBaseDir(tempFolder, "/jsf/missingPomMojarraApi.jar", "/missingPomMojarraApi.jar");
        idata.setVariable(apiPathVar, tempFolder.getRoot().getPath() + "/api-mojarra.jar");
        idata.setVariable(implPathVar, tempFolder.getRoot().getPath() + "/impl-mojarra.jar");
        idata.setVariable(toValidateVar, "jsfimpl.input");
        idata.setVariable(combinedMsgVar, "");
    }


}
