package com.redhat.installer.tests.installation.action;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.RulesEngine;
import com.redhat.installer.installation.action.ShortcutHelper;
import com.redhat.installer.framework.testers.PanelActionTester;
import org.junit.Before;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

/**
 * Class performs simple math, make sure it's correct
 * Created by thauser on 9/3/14.
 */
public class ShortcutHelperTest extends PanelActionTester{
    private final String STANDALONE_MANAGEMENT_CONSOLE_HTTP = "standalone.xml.management-http";
    private final String STANDALONE_MANAGEMENT_CONSOLE_HTTPS = "standalone.xml.management-https";

    private final String DOMAIN_CONSOLE_HTTP = "host.management-http";
    private final String DOMAIN_CONSOLE_HTTPS = "domain.default.management-https-2";

    private final String SHORTCUT_DOMAIN_MANAGEMENT_CONSOLE_PORT = "domain.shortcut.port";
    private final String SHORTCUT_STANDALONE_MANAGEMENT_CONSOLE_PORT = "standalone.shortcut.port";

    private static final String OFFSET_VARIABLE = "portOffsetType";
    private static final String OFFSET_WANTED_KEY = "portDecision";

    @Before
    public void before() {
        idata = AutomatedInstallData.getInstance();
        panelAction = new ShortcutHelper();
        idata.setVariable(STANDALONE_MANAGEMENT_CONSOLE_HTTP,"${test:9990}");
        idata.setVariable(STANDALONE_MANAGEMENT_CONSOLE_HTTPS, "${test:9443}");
        idata.setVariable(DOMAIN_CONSOLE_HTTP, "${test:9000}");
        idata.setVariable(DOMAIN_CONSOLE_HTTPS, "${test:9500}");
        RulesEngine rules = new RulesEngine((IXMLElement) null, idata);
        idata.setRules(rules);
    }

    @Test
    public void testSSL(){
        panelAction.executeAction(idata, handler);
        assertEquals("9443", idata.getVariable(SHORTCUT_STANDALONE_MANAGEMENT_CONSOLE_PORT));
        assertEquals("9500", idata.getVariable(SHORTCUT_DOMAIN_MANAGEMENT_CONSOLE_PORT));
    }

    @Test
    public void testSSLOffset(){
        idata.setVariable(OFFSET_VARIABLE, "100");
        idata.setVariable(OFFSET_WANTED_KEY, "assist");
        panelAction.executeAction(idata, handler);
        assertEquals("9543", idata.getVariable(SHORTCUT_STANDALONE_MANAGEMENT_CONSOLE_PORT));
        assertEquals("9600", idata.getVariable(SHORTCUT_DOMAIN_MANAGEMENT_CONSOLE_PORT));
    }



}
