package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.CommandRunner;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

public class CommandRunnerTest extends ProcessPanelTester {

    @Before
    public void setUp() throws Exception {
        tempFolder.newFile(TestUtils.testLogFilename);
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "CommandRunner.running",
                "CommandRunner.failure", "CommandRunner.success", "CommandRunner.mute.failure", "CommandRunner.IOFailure");
    }

    @Test
    public void testSuccess() {
        assertTrue(CommandRunner.run(handler, new String[]{"git", "--version"}));
    }

    @Test
    public void testFailure() {
        assertFalse(CommandRunner.run(handler, new String[]{"doesnt-exist"}));
    }

    @Test
    public void testMuteSuccess(){
        assertTrue(CommandRunner.run(handler, new String[]{"--mute=true", "git", "--version"}));
    }

    @Test
    public void testMuteFailure(){
        assertFalse(CommandRunner.run(handler, new String[]{"--mute=true", "doesnt-exist"}));
    }
}
