package com.redhat.installer.tests.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.installation.processpanel.TomcatAddDataSource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

public class TomcatAddDataSourceTest extends TomcatAddResourceTest {

    @Test
    public void testSuccess() throws Exception {
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatAddDataSource.run(handler, this.getTestArguments());
        assertCorrect(result,
                "Resource[driverclassname=org.postgresql.Driver][name=tom/test][maxTotal=1000][username=testerino][password=hogwash]");
    }
}
