package com.izforge.izpack.panels;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkListener;

import com.izforge.izpack.gui.FocusListenerAutoScroll;
import com.izforge.izpack.gui.FocusListenerRepaint;
import com.izforge.izpack.util.Debug;

import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URISyntaxException;


/**
 * Created by daniel on 11/28/16.
 */
public class JTextUrlPane extends JTextArea {

    private ArrayList<JTextPane> focusableFields;

    public JTextUrlPane() {
        this.setLayout(new com.izforge.izpack.gui.FlowLayout(com.izforge.izpack.gui.FlowLayout.LEADING, 0, 2));
        focusableFields = new ArrayList<JTextPane>();
    }

    private void setHtml(JTextPane p, String style, String text) {

        HTMLDocument htmlDocument;

        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        htmlDocument = (HTMLDocument) htmlEditorKit.createDefaultDocument();
        p.setEditorKit(htmlEditorKit);
        p.setDocument(htmlDocument);

        Element e = htmlDocument.getRootElements()[0];

        Element bodyElement = e.getElement(0);
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append(style + text + "</p>");

        StyleSheet ss = htmlDocument.getStyleSheet();

        try {
            htmlDocument.insertAfterStart(bodyElement, sbHtml.toString());
        } catch (BadLocationException e1) {
            e1.printStackTrace();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
        ss.addRule("p {margin-top:0;}\n");
    }

    private JTextPane createTextPane(String text, String style, boolean isHyperlink) {
        JTextPane p = new JTextPane();
        p.setEditable(false);
        setHtml(p, style, text);

        if (isHyperlink) {
            p.addFocusListener(new FocusListenerRepaint());
            p.addHyperlinkListener(new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(e.getURL().toURI());
                            } catch (IOException e1) {
                                Debug.trace(e1);
                            } catch (URISyntaxException e1) {
                                Debug.trace(e1);
                            }
                        }
                    }
                }
            });
            p.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "Hyperlink");
            p.getActionMap().put("Hyperlink", new HyperlinkAction());
        } else {
            p.setFocusable(false);
        }

        return p;
    }

    public void setText(String text) {
        boolean matchFound;
        boolean first = true;
        JTextPane firstComp;

        Pattern p = Pattern.compile("<p style=(.*?)>");
        Matcher m = p.matcher(text);
        String style = m.find() ? m.group() : "";

        p = Pattern.compile("<a href=(.*?)</a>");
        m = p.matcher(text);
        matchFound = m.find();
        String[] inputText = text.split("<a href=(.*?)</a>");

        for (String normalText : inputText) {
            String cleanedText = normalText.replaceAll("<[^>]*>", "");
            JTextPane preHyperlink = cleanedText.isEmpty() ? null : createTextPane(cleanedText, style, false);
            JTextPane hyperlink = null;

            if (matchFound) {
                hyperlink = createTextPane(m.group(), style, true);
            }

            if (first) {
                first = false;
                firstComp = preHyperlink == null ? hyperlink : preHyperlink;
                firstComp.setMargin(new java.awt.Insets(3, 0, 3, 3));
            }

            if (preHyperlink != null) this.add(preHyperlink);
            if (hyperlink != null) {
                hyperlink.addFocusListener(new FocusListenerAutoScroll());
                this.add(hyperlink);
            }

            focusableFields.add(hyperlink);

            matchFound = m.find();
        }

/*        while(matchFound) {

            String cleanedText = inputText[0].replaceAll("<[^>]*>","");
            JTextPane preHyperlink = cleanedText.isEmpty()? null : createTextPane(cleanedText, style, false);

            JTextPane hyperlink = createTextPane(m.group(), style, true);

            if(first){
                first = false;
                firstComp = preHyperlink == null? hyperlink: preHyperlink;
                firstComp.setMargin(new java.awt.Insets(3, 0, 3, 3));
            }

            if(preHyperlink != null) this.add(preHyperlink);
            hyperlink.addFocusListener(new FocusListenerAutoScroll());
            this.add(hyperlink);

            focusableFields.add(hyperlink);

            if (inputText.length > 1){
                text = inputText[1];
            }

            matchFound = m.find();
        }*/
    }

    @Override
    public Dimension getPreferredSize() {
        int totalWidth = 0;
        for (Component comp : getComponents()) {
            totalWidth += comp.getPreferredSize().width;
        }
        return new Dimension(totalWidth, super.getPreferredSize().height + 3);
    }

    public ArrayList<JTextPane> getFocusableFields() {
        return focusableFields;
    }
}

class HyperlinkAction extends TextAction {
    public HyperlinkAction() {
        super("Hyperlink");
    }

    public void actionPerformed(ActionEvent ae) {
        JTextPane component = (JTextPane) getFocusedComponent();
        HTMLDocument doc = (HTMLDocument) component.getDocument();
        int position = 1;
        Element e = doc.getCharacterElement(position);
        AttributeSet as = e.getAttributes();
        AttributeSet anchor = (AttributeSet) as.getAttribute(HTML.Tag.A);

        if (anchor != null) {
            try {
                Rectangle r = component.modelToView(position);

                MouseEvent me = new MouseEvent(
                        component,
                        MouseEvent.MOUSE_CLICKED,
                        System.currentTimeMillis(),
                        InputEvent.BUTTON1_MASK,
                        r.x,
                        r.y,
                        1,
                        false);

                component.dispatchEvent(me);
            } catch (BadLocationException ble) {
            }
        }
    }
}

