/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.client.validation.canvas;

import java.util.Collection;

import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;

@NonPortable
public class CanvasValidationFailEvent extends CanvasValidationEvent {

    private final Collection<DiagramElementViolation<RuleViolation>> violations;

    public CanvasValidationFailEvent(final String uuid,
                                     final String diagramName,
                                     final String diagramTitle,
                                     final Collection<DiagramElementViolation<RuleViolation>> violations) {
        super(uuid,
              diagramName,
              diagramTitle);
        this.violations = violations;
    }

    public Collection<DiagramElementViolation<RuleViolation>> getViolations() {
        return violations;
    }
}
