#include "YODA/Histo.h"
#include "YODA/ReaderYODA.h"
#include "YODA/IO.h"
#include <iostream>

using namespace std;
using namespace YODA;

int main() {

  vector<AnalysisObject*> aos1 = YODA::read("testwriter2.yoda");
  if (aos1.size() != 8)  return EXIT_FAILURE;

  #ifdef HAVE_LIBZ
  vector<AnalysisObject*> aos2 = YODA::read("testwriter2.yoda.gz");
  if (aos2.size() != 11)  return EXIT_FAILURE;
  #endif

  #ifdef HAVE_HDF5
  vector<AnalysisObject*> aos3 = YODA::read("testwriter2.yoda.h5");
  if (aos3.size() != 11)  return EXIT_FAILURE;

  aos3 = YODA::read("testwriter2.yoda.h5", "C");
  if (aos3.size() != 1)  return EXIT_FAILURE;

  aos3 = YODA::read("testwriter2.yoda.h5", "H");
  if (aos3.size() != 2)  return EXIT_FAILURE;

  aos3 = YODA::read("testwriter2.yoda.h5", "E");
  if (aos3.size() != 3)  return EXIT_FAILURE;

  aos3 = YODA::read("testwriter2.yoda.h5", "S");
  if (aos3.size() != 3)  return EXIT_FAILURE;
  #endif

  return EXIT_SUCCESS;
}
